#include <iostream>
#include <fstream>
#include "console.h"
#include "filelib.h"
#include "simpio.h"
#include "pagerank.h"
using namespace std;


int main()
{
    setConsoleSize(800, 200);
    setConsoleLocation(100, 600);

    while (true) {
        string filename = getLine("Enter path to links file (e.g. res/small.txt): ");
        if (filename.empty()) break;

        Map<string, Set<string>> links;
        ifstream in;
        if (!openFile(in, filename)) {
            cout << "Cannot open file named " << filename << ". Try again." << endl;
        } else if (!(in >> links)) {
            cout << "Contents of " << filename << " is not correct format for links. Try again." << endl;
        } else {
            runSimulation(links);
        }
    }

    cout << "All done, exiting." << endl;
    return 0;
}

