#include <iostream>
#include "Graphics.h"
using namespace std;


int rgbToAnsi256(int rgb) {
    double r = (rgb >> 16) & 0xff;
    double g = (rgb >> 8) & 0xff;
    double b = rgb & 0xff;
    if (r == g && g == b) { // if rgb == grayscale
       if (r < 8) return 16;    // solid black
       if (r > 248) return 231; // solid white
       return round(((r - 8) / 247) * 24) + 232;
   }
   return 16 + (36 * round(r / 255 * 5)) + (6 * round(g / 255 * 5))  + round(b / 255 * 5);
}

string colorBox(int rgb)
{
    // set background to ansi color, output space, reset to default
    return "\033[48;5;" + to_string(rgbToAnsi256(rgb)) + "m" + " " + "\033[0m";
}

void printImage(Grid<bool>& g)
{
    cout << endl;
    for (int r = 0; r < g.numRows(); r++) {
        for (int c = 0; c < g.numCols(); c++) {
            cout << colorBox(g[r][c] ? 0xffffff : 0x0);
        }
        cout << endl;
    }
}

void printImage(Grid<int>& g)
{
    cout << endl;
    for (int r = 0; r < g.numRows(); r++) {
        for (int c = 0; c < g.numCols(); c++) {
            cout << colorBox(g[r][c]);
        }
        cout << endl;
    }
}
