#pragma once

/**
 * File: Graphics.h
 * ----------------
 * @author Julie Zelenski, Fall 2020, CS106M
 * Simple proof of concept for a graphics window container to
 * wrap around a SimpleTest unit test.
 */

#include <string>
#include "gwindow.h"
#include "grid.h"
#include "../pagerank.h"

std::string colorBox(int rgb);
void printImage(Grid<int>& g);


class SimpleTestGraphics
{
    public:

        SimpleTestGraphics( std::string name = "Simple Test Graphics", int width = 900, int height = 600, bool forPageRank = true) {
            _window = new GWindow(width, height);
            _window->setTitle(name);
            _window->setResizable(false);
            if (forPageRank) configGraphics(_window);
        }

        ~SimpleTestGraphics() {
            _window->setTitle(_window->getTitle() + " [close to complete test]");
            while (_window->isVisible()) ;
            delete _window;
        }

        GWindow* getWindow() { return _window; }

        void showImage(Grid<int>& image) {
            if (_window) {
                _window->getCanvas()->setPixels(image);
            } else {
                printImage(image);
            }
        }

private:
    GWindow *_window;
};
