/**
 * File: chords.cpp
 * ----------------
 * @author Julie Zelenski, Fall 2021, CS106M
 */

#include "random.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "visuals.h"
using namespace std;

static double distance(GPoint one, GPoint two)
{
    double dx = one.x - two.x;
    double dy = one.y - two.y;
    return sqrt(dx*dx + dy*dy);
}

/* Helper: Point pt is on circle centered at center
 * Rotate pt theta degrees clockwise on circle around center.
 */
void rotate(GPoint& pt, GPoint center, double theta)
{
    GDimension delta = {pt.x - center.x, pt.y - center.y};
    double newWidth = delta.width * cos(theta) - delta.height * sin(theta);
    double newHeight = delta.width * sin(theta) + delta.height * cos(theta);
    pt = GPoint(center.x + newWidth, center.y + newHeight);
}

/* Helper: Given two points on circle centered at center, choose
 * random angle theta and rotate both around circle by that angle.
 */
void randomRotate(GPoint center, GPoint& one, GPoint& two)
{
    double theta = randomReal(0, 2*PI);
    rotate(one, center, theta);
    rotate(two, center, theta);
}

// choose a random diameter
void randomDiameter(GPoint center, double radius, GPoint& start, GPoint &end)
{
    start = {center.x - radius, center.y };
    end = {center.x + radius, center.y };
    randomRotate(center, start, end);
}

void myChoose(GPoint center, double radius, GPoint& start, GPoint &end)
{
    // TODO: implement this function to choose a random chord for circle C
    // and store chord endpoints into ref parameters start and end
    // Circle C is centered at center with given radius
}


typedef void (*chooseFn)(GPoint center, double radius, GPoint& start, GPoint& end);

void drawChords(LCanvas& lc, int nTotal, chooseFn chooseChord, string how)
{
    string txt = integerToString(nTotal) + " chords, choose " + how + "\n";
    setLabelText(lc, txt);

    double size = min(lc.canvas->getWidth(), lc.canvas->getHeight());
    double radius = size/2;
    GPoint center = {radius, radius};
    int nLonger = 0;

    for (int i = 0; i < nTotal; i++) {
        GPoint start, end;
        chooseChord(center, radius, start, end);
        int color = BLUE;
        if (distance(start, end) >= radius) {
            nLonger++;
            color = YELLOW;
        }
        drawColoredLine(lc, color, start, end);
    }

    double estimate = double(nLonger)/nTotal;
    txt += integerToString(100*estimate) + "% are longer than radius";
    setLabelText(lc, txt);
}


PROVIDED_TEST("Counting chords")
{
    double size = 200;
    int nSim = 2;
    Vector<LCanvas> vec = createWindow("Count percentage of chords longer than radius", size, size, nSim);

    int nChords = 400;
    drawChords(vec[0], nChords, randomDiameter, "from diameters");
    drawChords(vec[1], nChords, myChoose, "my way");
}
