/**
 * File: darts.cpp
 * ---------------
 * @author Julie Zelenski, Fall 2021, CS106M
 */
#include "random.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "visuals.h"
using namespace std;

static double distance(GPoint one, GPoint two)
{
    double dx = one.x - two.x;
    double dy = one.y - two.y;
    return sqrt(dx*dx + dy*dy);
}

void throwDarts(LCanvas lc, int nDarts)
{
    string txt = integerToString(nDarts) + " darts\n";
    setLabelText(lc, txt);

    double size = min(lc.canvas->getWidth(), lc.canvas->getHeight());
    GPoint center = {size/2, size/2};
    int nInside = 0;

    for (int i = 0; i < nDarts; i++) {
        GPoint pt = { randomReal(0, size), randomReal(0, size) };
        int color = YELLOW;
        if (distance(pt, center) <= size/2) {
            nInside++;
            color = RED;
        }
        drawColoredPixel(lc, color, pt.x, pt.y);
    }

    double estimate = (4.0*nInside)/nDarts;
    txt += "pi = " + doubleToString(estimate);
    setLabelText(lc, txt);
}


PROVIDED_TEST("Throw darts")
{
    double size = 125;
    int nSim = 8;
    Vector<LCanvas> vec = createWindow("Monte Carlo Darts", size, size, nSim);

    for (int i = 0, nDarts = 1000; i < nSim; i++, nDarts *= 2) {
        throwDarts(vec[i], nDarts);
    }
}
