/**
 * File: roulette.cpp
 * ------------------
 * @author Julie Zelenski, Fall 2021, CS106M
 */
#include "random.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "visuals.h"
using namespace std;

int oneBet(int bet, double odds)
{
    if (randomChance(odds))
        return bet;
    else
        return -bet;
}

double randomWalk(double odds, int stake, int& n, int& low, int& high, LCanvas* pLC = nullptr)
{
    low = high = stake;
    int bet = 1; // bet a dollar each spin
    int cur = stake;

    for (n = 0; cur >= bet && cur < 2*stake; n++) { // quit when bankrupt or double
        cur += oneBet(bet, odds);
        low = min(cur, low);    // track high/low extremes
        high = max(cur, high);
        if (pLC) drawColoredPixel(*pLC, (cur > stake ? GREEN : RED), n, 2*stake - cur, true);
    }
    return cur - stake;  // return net gain/loss
}

void oneDay(LCanvas lc, double odds)
{
    string txt = "Odds of win = " + realToString(100*odds) + "% ";
    setLabelText(lc, txt);

    int n, low, high, stake = (lc.canvas->getHeight() - 1)/2;
    int net = randomWalk(odds, stake, n, low, high, &lc);

    txt += (net > 0 ? "Doubled after " : "Bankrupt after ") + integerToString(n) + " spins";
    setLabelText(lc, txt);
}

void oneYear(LCanvas lc, double odds)
{
    string txt = "Odds of win = " + realToString(100*odds) + "%\n";
    setLabelText(lc, txt);

    int n, overallGainLoss = 0;
    for (int y = 0; y < lc.canvas->getHeight(); y++) {
        int low, high, stake = (lc.canvas->getWidth())/2;
        int net = randomWalk(odds, stake, n, low, high);
        overallGainLoss += net;
        drawColoredLine(lc, (net > 0 ? GREEN : RED), GPoint(low, y), GPoint(high, y));
    }
    txt += "One year gain/loss = $" + integerToString(overallGainLoss);
    setLabelText(lc, txt);
}


static const double STANDARD_ODDS = 18.0/37;

PROVIDED_TEST("Monte Carlo roulette random walk, one day")
{
    double width = 800, height = 50;
    int nSim = 4;
    Vector<LCanvas> vec = createWindow("One day 50-50 vs Standard odds", width, height, 1, nSim);

    oneDay(vec[0], 0.50);
    oneDay(vec[1], 0.50);
    oneDay(vec[2], STANDARD_ODDS);
    oneDay(vec[3], STANDARD_ODDS);
    pause(2000);
}

PROVIDED_TEST("Monte Carlo roulette random walk, one year")
{
    double width = 200, height = 365;
    int nSim = 4;
    Vector<LCanvas> vec = createWindow("One year 50-50 vs Standard odds", width, height, nSim, 1);

    oneYear(vec[0], 0.50);
    oneYear(vec[1], 0.50);
    oneYear(vec[2], STANDARD_ODDS);
    oneYear(vec[3], STANDARD_ODDS);
}
