/**
 * File: visuals.cpp
 * -----------------
 * @author Julie Zelenski, Fall 2021, CS106M
 *
 * For Monte Carlo Simulation
 * Borrowing from earlier Fractals/PageRank
 */

#include "gbutton.h"
#include "gcolor.h"
#include "gcontainer.h"
#include "gobjects.h"
#include "grid.h"
#include "gwindow.h"
#include "visuals.h"
using namespace std;

int colorFromWheel(int huedegree) {
    // https://en.wikipedia.org/wiki/HSL_and_HSV
    double v = 0.95;
    double s = 1;
    double h = (360 + huedegree)/360.0;
    int i = h * 6;
    double f = h * 6 - i;
    double p = v * (1 - s);
    double q = v * (1 - f * s);
    double t = v * (1 - (1 - f) * s);
    double r,g,b;

    switch (i % 6) { // which sextant of color wheel
      case 0: r = v, g = t, b = p; break;
      case 1: r = q, g = v, b = p; break;
      case 2: r = p, g = v, b = t; break;
      case 3: r = p, g = q, b = v; break;
      case 4: r = t, g = p, b = v; break;
      case 5: r = v, g = p, b = q; break;
    }
    return GColor::convertRGBToRGB(r * 255, g * 255, b * 255);
}

void setLabelText(LCanvas& lc, std::string txt) {
    lc.label->setText(txt);
}

void drawColoredPixel(LCanvas& lc, int rgb, int x, int y, bool repaint) {
    int wrapy = y % lc.pixels->numRows();
    int wrapx = x % lc.pixels->numCols();
    (*lc.pixels)[wrapy][wrapx] = rgb;

    static int n = 0, BATCH_SIZE = 100;
    if (repaint || ++n % BATCH_SIZE == 0) {
        lc.canvas->setPixels(*lc.pixels);
        lc.canvas->repaint();
    }
}

void drawColoredLine(LCanvas& lc, int rgb, GPoint start, GPoint end) {
    lc.canvas->setColor(rgb);
    lc.canvas->drawLine(start, end);
    lc.canvas->repaint();
}

Vector<LCanvas> createWindow(std::string name, int width, int height, int nCols, int nRows) {
    double textHeight = 35;
    double margin = 6;
    double windowWidth = nCols * (width + 2*margin) + 2*margin;
    double windowHeight = nRows * (height + 2*margin + textHeight) + 2*margin;

    GWindow *win = new GWindow(windowWidth, windowHeight, false);
    win->setTitle(name);
    win->setResizable(false);
    Vector<LCanvas> vec;
    for (int i = 0; i < nRows*nCols; i++) {
        GContainer *container = new GContainer(GContainer::LAYOUT_FLOW_VERTICAL);
        GCanvas *canvas = new GCanvas(width, height);
        canvas->setAutoRepaint(false);   // control refresh manually
        canvas->setBackground(BLACK);
        GLabel *label = new GLabel(nRows == 1 ? "\n": "");
        container->add(canvas);
        container->add(label);
        Grid<int> *grid = new Grid<int>(height, width); // numrows, numcols
        vec.add({ canvas, label, grid });
        win->addToRegion(container, nRows == 1 ? GWindow::REGION_NORTH : GWindow::REGION_EAST);
    }
    win->setVisible(true);
    return vec;
}
