#pragma once

#include "glabel.h"
#include "gobjects.h"
#include "gwindow.h"
#include "vector.h"

const int RED    = 0xff0000;
const int GREEN  = 0x00ff00;
const int BLUE   = 0x0000ff;
const int YELLOW = 0xffff00;
const int WHITE  = 0xffffff;
const int BLACK  = 0;

// degree is any number from 0 - 360
// on color wheel 0 -> red, 120 -> green, 240 -> blue
int colorFromWheel(int degree);

struct LCanvas {
    GCanvas *canvas;
    GLabel *label;
    Grid<int> *pixels;
};

Vector<LCanvas> createWindow(std::string name, int width, int height, int nCols, int nRows = 1);

void drawColoredPixel(LCanvas& lc, int rgb, int x, int y, bool repaint = false);
void drawColoredLine(LCanvas& lc, int rgb, GPoint start, GPoint end);
void setLabelText(LCanvas& lc, std::string txt);
