/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.audio;

import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayerEvent;
import javazoom.jlgui.basicplayer.BasicPlayerListener;

public class SplClip
implements AudioClip,
BasicPlayerListener,
Runnable {
    private static final Set<String> SUPPORTED_EXTENSIONS = new TreeSet<String>(Arrays.asList("mp3", "ogg", "ogs", "wav", "wave"));
    private String filename;
    private BasicController control;
    private Clip clip;
    private Thread thread;
    private boolean loop;

    public static boolean supportsExtension(String extension) {
        return SUPPORTED_EXTENSIONS.contains(extension = String.valueOf(extension).toLowerCase()) || SUPPORTED_EXTENSIONS.contains("." + extension);
    }

    public static boolean supportsFile(String name) {
        return SplClip.supportsExtension(SplClip.getExtension(name));
    }

    public static String getExtension(String name) {
        String extension = (name.lastIndexOf(".") >= 0 ? name.substring(name.lastIndexOf(".") + 1) : name).toLowerCase();
        return extension;
    }

    public SplClip(String filename) {
        this.filename = filename;
    }

    public void loop() {
        this.play(true);
    }

    public void play() {
        this.play(false);
    }

    private void play(boolean loop) {
        this.loop = loop;
        String extension = SplClip.getExtension(this.filename);
        if (extension.equals("mp3")) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            try {
                File soundFile = new File(this.filename);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(audioInputStream);
                if (loop) {
                    this.clip.loop(-1);
                }
                this.clip.start();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
            catch (LineUnavailableException lue) {
                throw new IllegalArgumentException(lue);
            }
            catch (UnsupportedAudioFileException uafe) {
                throw new IllegalArgumentException(uafe);
            }
        }
    }

    public void run() {
        String extension = SplClip.getExtension(this.filename);
        try {
            if (extension.equals("mp3")) {
                do {
                    AudioInputStream in = AudioSystem.getAudioInputStream(new File(this.filename));
                    AudioInputStream din = null;
                    AudioFormat baseFormat = in.getFormat();
                    AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                    din = AudioSystem.getAudioInputStream(decodedFormat, in);
                    this.rawplay(decodedFormat, din);
                    in.close();
                } while (this.loop);
            } else {
                File soundFile = new File(this.filename);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(audioInputStream);
                if (this.loop) {
                    this.clip.loop(-1);
                }
                this.clip.start();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        catch (LineUnavailableException lue) {
            throw new IllegalArgumentException(lue);
        }
        catch (UnsupportedAudioFileException uafe) {
            throw new IllegalArgumentException(uafe);
        }
    }

    public void stop() {
        if (this.control != null) {
            this.control.stop();
            this.control = null;
        }
        if (this.clip != null) {
            this.clip.stop();
        }
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void waitUntilDonePlaying() {
        if (this.clip != null) {
            if (!this.clip.isRunning()) {
                while (!this.clip.isRunning()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            while (this.clip.isRunning()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void opened(Object stream, Map properties) {
    }

    public void progress(int bytesread, long microseconds, byte[] pcmdata, Map properties) {
    }

    public void stateUpdated(BasicPlayerEvent event) {
    }

    public void setController(BasicController controller) {
    }

    private void rawplay(AudioFormat targetFormat, AudioInputStream din) throws LineUnavailableException, IOException {
        byte[] data = new byte[65536];
        SourceDataLine line = this.getLine(targetFormat);
        if (line != null) {
            line.start();
            int nBytesRead = 0;
            while (nBytesRead != -1) {
                nBytesRead = din.read(data, 0, data.length);
                if (nBytesRead == -1) continue;
                line.write(data, 0, nBytesRead);
            }
            line.drain();
            line.stop();
            line.close();
            din.close();
        }
    }

    private SourceDataLine getLine(AudioFormat audioFormat) throws LineUnavailableException {
        SourceDataLine res = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        res = (SourceDataLine)AudioSystem.getLine(info);
        res.open(audioFormat);
        return res;
    }
}

