/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GRectangle;
import acm.graphics.PathElement;
import acm.graphics.PathState;
import java.awt.Graphics;

class DrawLineElement
extends PathElement {
    private double deltaX;
    private double deltaY;

    public DrawLineElement(double d, double d2) {
        this.deltaX = d;
        this.deltaY = d2;
    }

    public void paint(Graphics graphics, PathState pathState) {
        int n = GMath.round(pathState.sx * pathState.cx);
        int n2 = GMath.round(pathState.sy * pathState.cy);
        pathState.cx += this.deltaX;
        pathState.cy += this.deltaY;
        int n3 = GMath.round(pathState.sx * pathState.cx);
        int n4 = GMath.round(pathState.sy * pathState.cy);
        if (pathState.region == null) {
            graphics.drawLine(n, n2, n3, n4);
        } else {
            pathState.region.addPoint(n3, n4);
        }
    }

    public void updateBounds(GRectangle gRectangle, PathState pathState) {
        if (gRectangle.getWidth() < 0.0) {
            gRectangle.setBounds(pathState.sx * pathState.cx, pathState.sy * pathState.cy, 0.0, 0.0);
        } else {
            gRectangle.add(pathState.sx * pathState.cx, pathState.sy * pathState.cy);
        }
        pathState.cx += this.deltaX;
        pathState.cy += this.deltaY;
        gRectangle.add(pathState.sx * pathState.cx, pathState.sy * pathState.cy);
    }
}

