/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GLine
extends GObject {
    public static final double LINE_TOLERANCE = 1.5;
    private double dx;
    private double dy;
    static final long serialVersionUID = 21L;

    public GLine(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2);
        this.dx = d3 - d;
        this.dy = d4 - d2;
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.createTransformedGraphics(graphics);
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, GMath.round(this.dx), GMath.round(this.dy));
        graphics2D.draw(double_);
        graphics2D.dispose();
    }

    public GRectangle getBounds() {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = d + this.dx;
        double d4 = d2 + this.dy;
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            Point2D.Double double_ = new Point2D.Double(d, d2);
            affineTransform.transform(double_, double_);
            d = ((Point2D)double_).getX();
            d2 = ((Point2D)double_).getY();
            double_ = new Point2D.Double(d3, d4);
            affineTransform.transform(double_, double_);
            d3 = ((Point2D)double_).getX();
            d4 = ((Point2D)double_).getY();
        }
        double d5 = Math.min(d, d3);
        double d6 = Math.min(d2, d4);
        return new GRectangle(d5, d6, Math.abs(d3 - d) + 1.0, Math.abs(d4 - d2) + 1.0);
    }

    public void setStartPoint(double d, double d2) {
        this.dx += this.getX() - d;
        this.dy += this.getY() - d2;
        this.setLocation(d, d2);
    }

    public GPoint getStartPoint() {
        return this.getLocation();
    }

    public void setEndPoint(double d, double d2) {
        this.dx = d - this.getX();
        this.dy = d2 - this.getY();
        this.repaint();
    }

    public GPoint getEndPoint() {
        return new GPoint(this.getX() + this.dx, this.getY() + this.dy);
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = d3 + this.dx;
        double d6 = d4 + this.dy;
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            Point2D.Double double_ = new Point2D.Double(d3, d4);
            affineTransform.transform(double_, double_);
            d3 = ((Point2D)double_).getX();
            d4 = ((Point2D)double_).getY();
            double_ = new Point2D.Double(d5, d6);
            affineTransform.transform(double_, double_);
            d5 = ((Point2D)double_).getX();
            d6 = ((Point2D)double_).getY();
        }
        double d7 = 2.25;
        if (this.distanceSquared(d, d2, d3, d4) < d7) {
            return true;
        }
        if (this.distanceSquared(d, d2, d5, d6) < d7) {
            return true;
        }
        if (d < Math.min(d3, d5) - 1.5) {
            return false;
        }
        if (d > Math.max(d3, d5) + 1.5) {
            return false;
        }
        if (d2 < Math.min(d4, d6) - 1.5) {
            return false;
        }
        if (d2 > Math.max(d4, d6) + 1.5) {
            return false;
        }
        if ((float)d3 - (float)d5 == 0.0f && (float)d4 - (float)d6 == 0.0f) {
            return false;
        }
        double d8 = ((d - d3) * (d5 - d3) + (d2 - d4) * (d6 - d4)) / this.distanceSquared(d3, d4, d5, d6);
        return this.distanceSquared(d, d2, d3 + d8 * (d5 - d3), d4 + d8 * (d6 - d4)) < d7;
    }

    public String paramString() {
        String string = super.paramString();
        string = string.substring(string.indexOf(41) + 1);
        GPoint gPoint = this.getStartPoint();
        String string2 = "start=(" + gPoint.getX() + ", " + gPoint.getY() + ")";
        gPoint = this.getEndPoint();
        string2 = string2 + ", end=(" + gPoint.getX() + ", " + gPoint.getY() + ")";
        return string2 + string;
    }

    private double distanceSquared(double d, double d2, double d3, double d4) {
        return (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
    }
}

