/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class GRect
extends GObject
implements GFillable,
GResizable {
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 21L;

    public GRect(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GRect(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.createTransformedGraphics(graphics);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        if (this.isFilled()) {
            graphics2D.setColor(this.getFillColor());
            graphics2D.fill(double_);
            graphics2D.setColor(this.getColor());
        }
        graphics2D.draw(double_);
        graphics2D.dispose();
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void setSize(double d, double d2) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setSize: Object has been transformed");
        }
        this.frameWidth = d;
        this.frameHeight = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getBounds() {
        Rectangle2D rectangle2D = new Rectangle2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds();
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        return new GRectangle(rectangle2D2.getX() + this.getX(), rectangle2D2.getY() + this.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
    }

    public boolean contains(double d, double d2) {
        Shape shape = new Rectangle2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape.contains(d - this.getX(), d2 - this.getY());
    }

    protected double getFrameWidth() {
        return this.frameWidth;
    }

    protected double getFrameHeight() {
        return this.frameHeight;
    }
}

