/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.graphics.GContainer;
import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import stanford.spl.JBECanvas;
import stanford.spl.TopCompound;

public abstract class GInteractor
extends GObject
implements GResizable {
    private JComponent interactor;
    private String actionCommand;

    public GInteractor(JComponent jComponent) {
        this.interactor = jComponent;
        this.actionCommand = "";
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setSize(dimension.width, dimension.height);
    }

    public JComponent getInteractor() {
        return this.interactor;
    }

    @Override
    public GRectangle getBounds() {
        Point point = this.interactor.getLocation();
        Dimension dimension = this.interactor.getPreferredSize();
        return new GRectangle(point.x, point.y, dimension.width, dimension.height);
    }

    @Override
    public void setLocation(double d, double d2) {
        super.setLocation(d, d2);
        this.interactor.setLocation(GMath.round(d), GMath.round(d2));
        this.interactor.repaint();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.interactor.setVisible(bl);
        this.interactor.repaint();
    }

    @Override
    public void setParent(GContainer gContainer) {
        TopCompound topCompound;
        JBECanvas jBECanvas;
        if (gContainer == null) {
            this.interactor.getParent().remove(this.interactor);
        } else if (gContainer instanceof TopCompound && (jBECanvas = (topCompound = (TopCompound)gContainer).getCanvas()) != null) {
            jBECanvas.add(this.interactor);
            jBECanvas.validate();
        }
    }

    @Override
    public void setSize(double d, double d2) {
        int n = GMath.round(d);
        int n2 = GMath.round(d2);
        this.interactor.setPreferredSize(new Dimension(n, n2));
        this.interactor.setSize(n, n2);
        this.interactor.repaint();
    }

    @Override
    public void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    @Override
    public void setBounds(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2);
        this.setSize(d3, d4);
    }

    @Override
    public void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    protected void paintObject(Graphics graphics) {
    }
}

