/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.util.ErrorException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCompound
extends GObject
implements GContainer {
    private boolean complete = false;
    private GObjectList contents = new GObjectList(this);
    private transient GObject lastObject;
    private transient GObject dragObject;
    static final long serialVersionUID = 21L;

    @Override
    public void add(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't add objects to a GCompound that has been marked as complete.");
        }
        this.contents.add(gObject);
        this.repaint();
    }

    @Override
    public final void add(GObject gObject, double d, double d2) {
        gObject.setLocation(d, d2);
        this.add(gObject);
    }

    @Override
    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject, gPoint.getX(), gPoint.getY());
    }

    @Override
    public void remove(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.remove(gObject);
        this.repaint();
    }

    @Override
    public void removeAll() {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.removeAll();
        this.repaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int n) {
        return this.contents.getElement(n);
    }

    @Override
    public GObject getElementAt(double d, double d2) {
        return this.contents.getElementAt(d, d2, false);
    }

    @Override
    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int n) {
        return new GIterator(this, n);
    }

    @Override
    public Object clone() {
        try {
            GCompound gCompound = (GCompound)super.clone();
            gCompound.contents = new GObjectList(gCompound, this.contents);
            for (int i = 0; i < this.contents.getElementCount(); ++i) {
                System.err.println("original = " + this.contents.getElement(i).hashCode());
                System.err.println("clone    = " + gCompound.contents.getElement(i).hashCode());
            }
            return gCompound;
        }
        catch (Exception exception) {
            throw new ErrorException("Impossible exception");
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.createTransformedGraphics(graphics);
        this.contents.mapPaint(graphics2D);
        graphics2D.dispose();
    }

    @Override
    public GRectangle getBounds() {
        GRectangle gRectangle = this.contents.getBounds();
        Shape shape = new Rectangle2D.Double(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        Rectangle rectangle = shape.getBounds();
        return new GRectangle(this.getX() + ((RectangularShape)rectangle).getX(), this.getY() + ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
    }

    @Override
    public boolean contains(double d, double d2) {
        d -= this.getX();
        d2 -= this.getY();
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            try {
                affineTransform = affineTransform.createInverse();
                Point2D.Double double_ = new Point2D.Double(d, d2);
                affineTransform.transform(double_, double_);
                d = ((Point2D)double_).getX();
                d2 = ((Point2D)double_).getY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new ErrorException(noninvertibleTransformException);
            }
        }
        return this.contents.contains(d, d2);
    }

    public final GPoint getCanvasPoint(GPoint gPoint) {
        return this.getCanvasPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getCanvasPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d += gCompound.getX();
            d2 += gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public final GPoint getLocalPoint(GPoint gPoint) {
        return this.getLocalPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocalPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d -= gCompound.getX();
            d2 -= gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public void markAsComplete() {
        this.complete = true;
    }

    protected void sendToFront(GObject gObject) {
        this.contents.sendToFront(gObject);
        this.repaint();
    }

    protected void sendToBack(GObject gObject) {
        this.contents.sendToBack(gObject);
        this.repaint();
    }

    protected void sendForward(GObject gObject) {
        this.contents.sendForward(gObject);
        this.repaint();
    }

    protected void sendBackward(GObject gObject) {
        this.contents.sendBackward(gObject);
        this.repaint();
    }

    @Override
    protected void fireMouseListeners(MouseEvent mouseEvent) {
        int n;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(mouseEvent);
            return;
        }
        GPoint gPoint = new GPoint((double)mouseEvent.getX() - this.getX(), (double)mouseEvent.getY() - this.getY());
        GObject gObject = this.getElementAt(gPoint);
        MouseEvent mouseEvent2 = null;
        if (gObject != this.lastObject) {
            if (this.lastObject != null) {
                mouseEvent2 = GCanvas.createMouseEvent(this.lastObject, 505, mouseEvent);
                this.lastObject.fireMouseListeners(mouseEvent2);
            }
            if (gObject != null) {
                mouseEvent2 = GCanvas.createMouseEvent(gObject, 504, mouseEvent);
                gObject.fireMouseListeners(mouseEvent2);
            }
        }
        this.lastObject = gObject;
        if (this.dragObject != null) {
            gObject = this.dragObject;
        }
        if (gObject != null && (n = mouseEvent.getID()) != 505 && n != 504) {
            if (n == 501) {
                this.dragObject = gObject;
            } else if (n == 502) {
                this.dragObject = null;
            }
            mouseEvent2 = GCanvas.createMouseEvent(gObject, n, mouseEvent);
            gObject.fireMouseListeners(mouseEvent2);
        }
        if (mouseEvent2 != null && mouseEvent2.isConsumed()) {
            mouseEvent.consume();
        }
    }

    @Override
    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        return this.contents.areMouseListenersEnabled();
    }
}

