/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.program.Program;
import acm.util.Base64OutputStream;
import acm.util.DOSCommandLine;
import acm.util.EmptyContainer;
import acm.util.ErrorException;
import acm.util.ExportAppletDialog;
import acm.util.HexByteOutputStream;
import acm.util.MailStream;
import acm.util.NullOutputStream;
import acm.util.Platform;
import acm.util.ProgressBarDialog;
import acm.util.SubmitOptions;
import acm.util.ThreadedMenuAction;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;

public class JTFTools {
    private static final String[] SKIP_FILES = new String[]{".DS_Store", "FINDER.DAT", "RESOURCE.FRK"};
    private static final String[] RESOURCE_EXTENSIONS = new String[]{".txt", ".dat", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav", ".class"};
    private static final String[] SUBMIT_EXTENSIONS = new String[]{".java", ".html", ".txt", ".dat", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav"};
    private static HashMap<Component, SubmitOptions> optionsTable = new HashMap();
    private static final int BUFFER_SIZE = 4096;
    private static final String[] SERIF_SUBSTITUTIONS = new String[]{"Serif", "Times", "TimesRoman", "Times-Roman"};
    private static final String[] SANSSERIF_SUBSTITUTIONS = new String[]{"SansSerif", "Helvetica", "Arial"};
    private static final String[] MONOSPACED_SUBSTITUTIONS = new String[]{"Monospaced", "Courier", "Monaco"};
    private static final String[] SKIP_JARS = new String[]{"acm.jar", "acm11.jar", "swingall.jar", "patchJTF.jar"};
    private static boolean fontFamilyTableInitialized = false;
    private static String[] fontFamilyArray = null;
    private static HashMap<String, String> fontFamilyTable = null;
    private static HashMap<Thread, Applet> appletTable = new HashMap();
    private static Applet mostRecentApplet = null;
    private static SecurityManager managerThatFails = null;
    private static String debugOptions = null;

    private JTFTools() {
    }

    public static void pause(double d) {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
            appletTable.put(Thread.currentThread(), applet);
        }
        try {
            int n = (int)d;
            int n2 = (int)Math.round((d - (double)n) * 1000000.0);
            Thread.sleep(n, n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Container createEmptyContainer() {
        return new EmptyContainer();
    }

    public static Frame getEnclosingFrame(Component component) {
        if (component instanceof Program) {
            component = ((Program)component).getContentPane();
        }
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static Font getStandardFont(Font font) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        if (font == null || fontFamilyTable == null) {
            return font;
        }
        String string = font.getFamily();
        if (fontFamilyTable.get(JTFTools.trimFamilyName(string)) != null) {
            return font;
        }
        if (string.equals("Serif") || string.equals("Times")) {
            string = JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS);
        } else if (string.equals("SansSerif")) {
            string = JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS);
        } else if (string.equals("Monospaced")) {
            string = JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS);
        } else {
            return font;
        }
        if (string == null) {
            return font;
        }
        return new Font(string, font.getStyle(), font.getSize());
    }

    public static String[] getFontList() {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        return fontFamilyArray;
    }

    public static String findFontFamily(String string) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = fontFamilyTable.get(JTFTools.trimFamilyName(stringTokenizer.nextToken()));
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public static Font decodeFont(String string) {
        return JTFTools.decodeFont(string, null);
    }

    public static Font decodeFont(String string, Font font) {
        String string2 = string;
        int n = font == null ? 0 : font.getStyle();
        int n2 = font == null ? 12 : font.getSize();
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            String string3 = string = string.substring(n3 + 1).toLowerCase();
            n3 = string.indexOf(45);
            if (n3 >= 0) {
                string3 = string.substring(0, n3);
                string = string.substring(n3 + 1);
            } else {
                string = "*";
            }
            if (Character.isDigit(string3.charAt(0))) {
                String string4 = string3;
                string3 = string;
                string = string4;
            }
            if (string3.equals("plain")) {
                n = 0;
            } else if (string3.equals("bold")) {
                n = 1;
            } else if (string3.equals("italic")) {
                n = 2;
            } else if (string3.equals("bolditalic")) {
                n = 3;
            } else if (!string3.equals("*")) {
                throw new ErrorException("Illegal font style");
            }
            if (!string.equals("*")) {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ErrorException("Illegal font size");
                }
            }
        }
        if (string2.equals("*")) {
            string2 = font == null ? "Default" : font.getName();
        } else {
            if (!fontFamilyTableInitialized) {
                JTFTools.initFontFamilyTable();
            }
            if (fontFamilyTable != null && (string2 = fontFamilyTable.get(JTFTools.trimFamilyName(string2))) == null) {
                string2 = "Default";
            }
        }
        return JTFTools.getStandardFont(new Font(string2, n, n2));
    }

    public static Color decodeColor(String string) {
        if (string.equalsIgnoreCase("desktop")) {
            return SystemColor.desktop;
        }
        if (string.equalsIgnoreCase("activeCaption")) {
            return SystemColor.activeCaption;
        }
        if (string.equalsIgnoreCase("activeCaptionText")) {
            return SystemColor.activeCaptionText;
        }
        if (string.equalsIgnoreCase("activeCaptionBorder")) {
            return SystemColor.activeCaptionBorder;
        }
        if (string.equalsIgnoreCase("inactiveCaption")) {
            return SystemColor.inactiveCaption;
        }
        if (string.equalsIgnoreCase("inactiveCaptionText")) {
            return SystemColor.inactiveCaptionText;
        }
        if (string.equalsIgnoreCase("inactiveCaptionBorder")) {
            return SystemColor.inactiveCaptionBorder;
        }
        if (string.equalsIgnoreCase("window")) {
            return SystemColor.window;
        }
        if (string.equalsIgnoreCase("windowBorder")) {
            return SystemColor.windowBorder;
        }
        if (string.equalsIgnoreCase("windowText")) {
            return SystemColor.windowText;
        }
        if (string.equalsIgnoreCase("menu")) {
            return SystemColor.menu;
        }
        if (string.equalsIgnoreCase("menuText")) {
            return SystemColor.menuText;
        }
        if (string.equalsIgnoreCase("text")) {
            return SystemColor.text;
        }
        if (string.equalsIgnoreCase("textText")) {
            return SystemColor.textText;
        }
        if (string.equalsIgnoreCase("textHighlight")) {
            return SystemColor.textHighlight;
        }
        if (string.equalsIgnoreCase("textHighlightText")) {
            return SystemColor.textHighlightText;
        }
        if (string.equalsIgnoreCase("textInactiveText")) {
            return SystemColor.textInactiveText;
        }
        if (string.equalsIgnoreCase("control")) {
            return SystemColor.control;
        }
        if (string.equalsIgnoreCase("controlText")) {
            return SystemColor.controlText;
        }
        if (string.equalsIgnoreCase("controlHighlight")) {
            return SystemColor.controlHighlight;
        }
        if (string.equalsIgnoreCase("controlLtHighlight")) {
            return SystemColor.controlLtHighlight;
        }
        if (string.equalsIgnoreCase("controlShadow")) {
            return SystemColor.controlShadow;
        }
        if (string.equalsIgnoreCase("controlDkShadow")) {
            return SystemColor.controlDkShadow;
        }
        if (string.equalsIgnoreCase("scrollbar")) {
            return SystemColor.scrollbar;
        }
        if (string.equalsIgnoreCase("info")) {
            return SystemColor.info;
        }
        if (string.equalsIgnoreCase("infoText")) {
            return SystemColor.infoText;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.DARK_GRAY;
        }
        if (string.equalsIgnoreCase("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.LIGHT_GRAY;
        }
        if (string.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorException("Illegal color value");
        }
    }

    public static boolean matchFilenamePattern(String string, String string2) {
        return JTFTools.recursiveMatch(string, 0, string2, 0);
    }

    public static void registerApplet(Applet applet) {
        JTFTools.registerApplet(applet, Thread.currentThread());
        mostRecentApplet = applet;
    }

    public static void registerApplet(Applet applet, Thread thread) {
        appletTable.put(thread, applet);
    }

    public static Applet getApplet() {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
        }
        return applet;
    }

    public static void setDebugOptions(String string) {
        debugOptions = string == null ? null : "+" + string.toLowerCase() + "+";
    }

    public static boolean testDebugOption(String string) {
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.indexOf("+" + string.toLowerCase() + "+") >= 0;
    }

    public static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return JTFTools.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return JTFTools.getShellCommandLine();
    }

    public static String getMainClass() {
        String string = null;
        try {
            string = System.getProperty("java.main");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = JTFTools.readMainClassFromClassPath();
        }
        if (string == null) {
            String string2 = JTFTools.getCommandLine();
            string = JTFTools.readMainClassFromCommandLine(string2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfLoaded(String string) {
        if (Platform.compareVersion("1.2") < 0) {
            return false;
        }
        boolean bl = false;
        try {
            if (System.getSecurityManager() != null) {
                return false;
            }
            if (managerThatFails == null) {
                try {
                    Class<?> clazz = Class.forName("acm.util.SecurityManagerThatFails");
                    managerThatFails = (SecurityManager)clazz.newInstance();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            System.setSecurityManager(managerThatFails);
            try {
                bl = Class.forName(string) != null;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                bl = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            finally {
                System.setSecurityManager(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void terminateAppletThreads(Applet applet) {
        try {
            Thread thread = Thread.currentThread();
            Class<?> clazz = Class.forName("java.lang.Thread");
            Method method = clazz.getMethod("stop", new Class[0]);
            for (Thread thread2 : appletTable.keySet()) {
                if (thread2 == thread || !thread2.isAlive() || !JTFTools.isAnonymous(thread2) || applet != appletTable.get(thread2)) continue;
                method.invoke((Object)thread2, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAnonymous(Thread thread) {
        String string = thread.getName();
        if (!string.startsWith("Thread-")) {
            return false;
        }
        for (int i = 7; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static PrintStream openMailStream(String string, String string2, String string3) {
        return new MailStream(string, string2, string3);
    }

    public static void cancelMail(PrintStream printStream) {
        ((MailStream)printStream).cancel();
    }

    public static void sendStandardHeaders(PrintStream printStream, String string, String string2) {
        ((MailStream)printStream).sendStandardHeaders(string, string2);
    }

    public static OutputStream openHexByteOutputStream(PrintStream printStream) {
        return new HexByteOutputStream(printStream);
    }

    public static OutputStream openBase64OutputStream(PrintStream printStream) {
        return new Base64OutputStream(printStream);
    }

    public static void padBase64OutputStream(OutputStream outputStream) {
        ((Base64OutputStream)outputStream).pad();
    }

    public static void exportJar(File file, File file2, String string, Object object) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            JTFTools.dumpJarAndResources("", file2, zipOutputStream, null, string, null, false, object);
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public static boolean executeExportAction(Program program, String string) {
        if (string.equals("Export Applet") || string.equals("Submit Project")) {
            new Thread(new ThreadedMenuAction(program, string)).start();
            return true;
        }
        return false;
    }

    public static String getLocalHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            Class<?> clazz = inetAddress.getClass();
            Method method = clazz.getMethod("getCanonicalHostName", new Class[0]);
            return (String)method.invoke((Object)inetAddress, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void copyFile(File file, File file2) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            JTFTools.copyBytes(bufferedInputStream, bufferedOutputStream, file.length());
            bufferedInputStream.close();
            bufferedOutputStream.close();
            Platform.copyFileTypeAndCreator(file, file2);
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public static void copyBytes(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[4096];
        while (l > 0L) {
            int n = (int)Math.min(4096L, l);
            if ((n = inputStream.read(byArray, 0, n)) == -1) {
                return;
            }
            outputStream.write(byArray, 0, n);
            l -= (long)n;
        }
    }

    static String getURLSuffix(String string) {
        return string.substring(string.lastIndexOf(47) + 1);
    }

    static void exportApplet(Program program, JProgressBar jProgressBar) {
        try {
            File file;
            String string = program.getClass().getName();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            File file2 = new File(System.getProperty("user.dir"));
            File file3 = new File(System.getProperty("user.home"));
            ExportAppletDialog exportAppletDialog = new ExportAppletDialog(file3, program);
            File file4 = exportAppletDialog.chooseOutputDirectory();
            if (file4 == null) {
                return;
            }
            if (file4.exists()) {
                if (!file4.isDirectory()) {
                    file4 = new File(file4.getParent());
                }
            } else {
                file4.mkdir();
            }
            if (jProgressBar != null) {
                jProgressBar.setMaximum(JTFTools.countResources(file2, RESOURCE_EXTENSIONS, "acm.jar") + 1);
                ProgressBarDialog.popup(jProgressBar);
            }
            if ((file = new File(file2, "index.html")).canRead()) {
                JTFTools.copyFile(file, new File(file4, "index.html"));
            } else {
                JTFTools.dumpHTMLIndex(file4, program, string, string2);
            }
            if (jProgressBar != null) {
                if (ProgressBarDialog.hasBeenCancelled(jProgressBar)) {
                    return;
                }
                jProgressBar.setValue(jProgressBar.getValue() + 1);
            }
            JTFTools.dumpJarAndResources(file2, file4, string2 + ".jar", "acm.jar", jProgressBar, exportAppletDialog.exportFiles(), null);
            if (jProgressBar != null) {
                ProgressBarDialog.dismiss(jProgressBar);
            }
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    private static void initFontFamilyTable() {
        int n;
        fontFamilyTableInitialized = true;
        for (n = 1; fontFamilyArray == null && n <= 2; ++n) {
            try {
                Method method;
                Class<?> clazz;
                if (n == 1) {
                    clazz = Class.forName("java.awt.GraphicsEnvironment");
                    method = clazz.getMethod("getLocalGraphicsEnvironment", new Class[0]);
                    Method method2 = clazz.getMethod("getAvailableFontFamilyNames", new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    fontFamilyArray = (String[])method2.invoke(object, new Object[0]);
                    continue;
                }
                clazz = Class.forName("java.awt.Toolkit");
                method = clazz.getMethod("getFontList", new Class[0]);
                fontFamilyArray = (String[])method.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fontFamilyTable = new HashMap();
        for (n = 0; n < fontFamilyArray.length; ++n) {
            fontFamilyTable.put(JTFTools.trimFamilyName(fontFamilyArray[n]), fontFamilyArray[n]);
        }
        fontFamilyTable.put("serif", JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS));
        fontFamilyTable.put("sansserif", JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS));
        fontFamilyTable.put("monospaced", JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS));
    }

    private static String getFirstAvailableFontSubstitution(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (fontFamilyTable.get(JTFTools.trimFamilyName(stringArray[i])) == null) continue;
            return stringArray[i];
        }
        return null;
    }

    private static String trimFamilyName(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '-') continue;
            string2 = string2 + Character.toLowerCase(c);
        }
        return string2;
    }

    private static boolean recursiveMatch(String string, int n, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        if (n2 == n4) {
            return n == n3;
        }
        char c = string2.charAt(n2);
        if (c == '*') {
            for (int i = n; i <= n3; ++i) {
                if (!JTFTools.recursiveMatch(string, i, string2, n2 + 1)) continue;
                return true;
            }
            return false;
        }
        if (n == n3) {
            return false;
        }
        char c2 = string.charAt(n);
        if (c == '[') {
            boolean bl = false;
            boolean bl2 = false;
            if (++n2 == n4) {
                throw new ErrorException("matchFilenamePattern: missing ]");
            }
            if (string2.charAt(n2) == '^') {
                ++n2;
                bl2 = true;
            }
            while (n2 < n4 && string2.charAt(n2) != ']') {
                if (n2 + 2 < n4 && string2.charAt(n2 + 1) == '-') {
                    bl |= c2 >= string2.charAt(n2) && c2 <= string2.charAt(n2 + 2);
                    n2 += 3;
                    continue;
                }
                bl |= c2 == string2.charAt(n2);
                ++n2;
            }
            if (n2 == n4) {
                throw new ErrorException("matchFilenamePattern: missing ]");
            }
            if (bl == bl2) {
                return false;
            }
        } else if (c != '?' && c != c2) {
            return false;
        }
        return JTFTools.recursiveMatch(string, n + 1, string2, n2 + 1);
    }

    private static String getShellCommandLine() {
        try {
            String string = Platform.isMac() ? "command" : "args";
            String[] stringArray = new String[]{"bash", "-c", "ps -p $PPID -o " + string};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            if (process.getErrorStream().read() != -1) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.readLine();
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String readMainClassFromManifest(String string) {
        try {
            ZipFile zipFile;
            ZipEntry zipEntry;
            if (JTFTools.testDebugOption("main")) {
                System.out.println("Read class from JAR manifest in " + string);
            }
            if ((zipEntry = (zipFile = new ZipFile(string)).getEntry("META-INF/MANIFEST.MF")) == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("Main-Class:")) {
                    String string3 = string2.substring("Main-Class:".length()).trim();
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + string3);
                    }
                    return string3;
                }
                string2 = bufferedReader.readLine();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String readMainClassFromCommandLine(String string) {
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from command line: " + string);
        }
        if (string == null) {
            return null;
        }
        boolean bl = false;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            boolean bl2 = false;
            while (true) {
                int n = streamTokenizer.nextToken();
                String string2 = streamTokenizer.sval;
                switch (n) {
                    case -1: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (bl2) {
                    if (string2.startsWith("-")) {
                        if (string2.equals("-jar")) {
                            bl = true;
                            continue;
                        }
                        if (!string2.equals("-cp") && !string2.equals("-classpath")) continue;
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl) {
                        return JTFTools.readMainClassFromManifest(string2);
                    }
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + string2);
                    }
                    return string2;
                }
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String readMainClassFromClassPath() {
        Object object = null;
        String string = System.getProperty("java.class.path");
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string == null) {
            return null;
        }
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from class path: " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;");
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            Object object3;
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            String[] stringArray = null;
            if (file.isDirectory()) {
                stringArray = file.list();
            } else if (string2.endsWith(".jar") && !JTFTools.nameAppears(string2, SKIP_JARS)) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    object3 = new ArrayList();
                    object2 = zipFile.entries();
                    while (object2.hasMoreElements()) {
                        ((ArrayList)object3).add(object2.nextElement().getName());
                    }
                    stringArray = new String[((ArrayList)object3).size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = (String)((ArrayList)object3).get(i);
                    }
                }
                catch (IOException iOException) {
                    stringArray = null;
                }
            }
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                object3 = stringArray[i];
                if (!((String)object3).endsWith(".class") || ((String)(object2 = ((String)object3).substring(0, ((String)object3).lastIndexOf(".class")))).indexOf("/") != -1 || !JTFTools.checkIfLoaded((String)object2)) continue;
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    Class[] classArray = new Class[]{stringArray.getClass()};
                    if (clazz.getMethod("main", classArray) == null) continue;
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + (String)object2);
                    }
                    if (object != null) {
                        return null;
                    }
                    object = object2;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return object;
    }

    protected static void submitProject(Program program, JProgressBar jProgressBar) {
        SubmitOptions submitOptions = JTFTools.getOptions(program);
        if (submitOptions.popup() && submitOptions.isComplete()) {
            String string = program.getClass().getName();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            String string3 = "==" + System.currentTimeMillis() + "==";
            String string4 = submitOptions.getSMTPServer();
            String string5 = submitOptions.getAuthorName();
            String string6 = submitOptions.getAuthorEMail();
            String string7 = submitOptions.getSubmissionEMail();
            String string8 = string6;
            int n = string6.indexOf("@");
            if (n != -1) {
                string8 = string8.substring(0, n);
            }
            String string9 = string2 + "_" + string8;
            File file = new File(System.getProperty("user.dir"));
            if (jProgressBar != null) {
                jProgressBar.setMaximum(JTFTools.countResources(file, SUBMIT_EXTENSIONS, null));
                ProgressBarDialog.popup(jProgressBar);
            }
            PrintStream printStream = JTFTools.openMailStream(string4, string6, string7);
            JTFTools.sendStandardHeaders(printStream, string5, string2);
            printStream.println("Mime-Version: 1.0");
            printStream.println("Content-Type: multipart/mixed; boundary=\"" + string3 + '\"');
            printStream.println();
            printStream.println("--" + string3);
            printStream.println("Content-Transfer-Encoding: base64");
            printStream.println("Content-Type: application/zip; name=" + string9 + ".zip");
            printStream.println("Content-Disposition: attachment; filename=" + string9 + ".zip");
            JTFTools.submitDirectory(printStream, string9, jProgressBar);
            if (ProgressBarDialog.hasBeenCancelled(jProgressBar)) {
                JTFTools.cancelMail(printStream);
            }
            printStream.println("--" + string3 + "--");
            printStream.close();
            if (jProgressBar != null) {
                ProgressBarDialog.dismiss(jProgressBar);
            }
        }
    }

    private static void dumpHTMLIndex(File file, Program program, String string, String string2) throws IOException {
        File file2 = new File(file, "index.html");
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        Dimension dimension = program.getSize();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<meta name=\"generator\" content=\"ACM Java Libraries V1.1\">");
        printWriter.println("<title>" + string2 + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<center>");
        printWriter.println("<table border=2 cellpadding=0 cellspacing=0>");
        printWriter.println("<tr><td>");
        printWriter.println("<applet archive=\"" + string2 + ".jar\"");
        printWriter.println("        code=\"" + string.replace('.', '/') + ".class\"");
        printWriter.println("        width=" + dimension.width + " height=" + dimension.height + ">");
        printWriter.println("</applet>");
        printWriter.println("</td></tr>");
        printWriter.println("</table>");
        printWriter.println("</center>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private static void dumpJarAndResources(File file, File file2, String string, String string2, JProgressBar jProgressBar, boolean bl, Object object) throws IOException {
        File file3 = new File(file2, string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file3));
        JTFTools.dumpJarAndResources("", file, zipOutputStream, file2, string2, jProgressBar, bl, object);
        zipOutputStream.close();
    }

    private static void dumpJarAndResources(String string, File file, ZipOutputStream zipOutputStream, File file2, String string2, JProgressBar jProgressBar, boolean bl, Object object) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(jProgressBar)) {
            return;
        }
        JTFTools.dumpTree(string, file, zipOutputStream, file2, jProgressBar, 0, bl, object);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            File file3 = JTFTools.getLibrary(string3);
            if (file3 == null) continue;
            ZipFile zipFile = new ZipFile(file3);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                if (!JTFTools.nameAppears(string4, SKIP_FILES)) {
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    if (object != null && string4.endsWith(".class")) {
                        zipEntry = new ZipEntry(string4);
                        zipOutputStream.putNextEntry(zipEntry);
                        JTFTools.transformClass(object, bufferedInputStream, zipOutputStream);
                    } else {
                        zipOutputStream.putNextEntry(zipEntry);
                        JTFTools.copyBytes(bufferedInputStream, zipOutputStream, zipEntry.getSize());
                    }
                    while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                        zipOutputStream.write(n);
                    }
                    zipOutputStream.closeEntry();
                    ((InputStream)bufferedInputStream).close();
                }
                if (jProgressBar == null) continue;
                jProgressBar.setValue(jProgressBar.getValue() + 1);
            }
        }
    }

    private static void dumpTree(String string, File file, ZipOutputStream zipOutputStream, File file2, JProgressBar jProgressBar, int n, boolean bl, Object object) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(jProgressBar)) {
            return;
        }
        String string2 = file.getName();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (n > 0) {
                string = string + string2 + "/";
            }
            for (int i = 0; i < stringArray.length; ++i) {
                JTFTools.dumpTree(string, new File(file, stringArray[i]), zipOutputStream, file2, jProgressBar, n + 1, bl, object);
            }
        } else if (JTFTools.isResourceComponent(string2)) {
            String string3 = string + string2;
            if (string3.startsWith("Java Classes/")) {
                string3 = string3.substring(string3.indexOf(47) + 1);
            }
            ZipEntry zipEntry = new ZipEntry(string3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            zipOutputStream.putNextEntry(zipEntry);
            if (object != null && string2.endsWith(".class")) {
                JTFTools.transformClass(object, bufferedInputStream, zipOutputStream);
            } else {
                JTFTools.copyBytes(bufferedInputStream, zipOutputStream, file.length());
            }
            ((InputStream)bufferedInputStream).close();
            if (bl && file2 != null && !string2.endsWith(".class")) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                file2 = new File(file2, string);
                File file3 = new File(file2, string2);
                file2.mkdirs();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                JTFTools.copyBytes(bufferedInputStream, bufferedOutputStream, file.length());
                ((InputStream)bufferedInputStream).close();
                bufferedOutputStream.close();
            }
            if (jProgressBar != null) {
                jProgressBar.setValue(jProgressBar.getValue() + 1);
            }
        }
    }

    private static void transformClass(Object object, InputStream inputStream, OutputStream outputStream) {
        Object[] objectArray;
        Method method = null;
        try {
            objectArray = new Class[]{Class.forName("java.io.InputStream"), Class.forName("java.io.OutputStream")};
            method = object.getClass().getMethod("transform", (Class<?>[])objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException("exportJar: Illegal class transformer object");
        }
        try {
            objectArray = new Object[]{inputStream, outputStream};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private static int countResources(File file, String[] stringArray, String string) {
        Object object;
        String string2 = file.getName();
        int n = 0;
        if (file.isDirectory()) {
            object = file.list();
            for (int i = 0; i < ((String[])object).length; ++i) {
                n += JTFTools.countResources(new File(file, object[i]), stringArray, null);
            }
        } else {
            for (int i = 0; i < stringArray.length && n == 0; ++i) {
                if (!string2.endsWith(stringArray[i])) continue;
                n = 1;
            }
        }
        if (string != null && (object = JTFTools.getLibrary(string)) != null) {
            try {
                ZipFile zipFile = new ZipFile((File)object);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ++n;
                    enumeration.nextElement();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private static File getLibrary(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (string.startsWith(".") || file.isAbsolute()) {
            return file;
        }
        String string2 = System.getProperty("java.class.path");
        if (string2 == null) {
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!((String)object).equals(string) && !((String)object).endsWith("/" + string)) continue;
            return new File((String)object);
        }
        object = new File(System.getProperty("user.dir"));
        file = new File((File)object, string);
        return file.exists() ? file : null;
    }

    private static boolean isResourceComponent(String string) {
        for (int i = 0; i < RESOURCE_EXTENSIONS.length; ++i) {
            if (!string.endsWith(RESOURCE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    private static void submitDirectory(PrintStream printStream, String string, JProgressBar jProgressBar) {
        try {
            OutputStream outputStream = JTFTools.openBase64OutputStream(printStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
            ZipOutputStream zipOutputStream2 = new ZipOutputStream(new NullOutputStream());
            File file = new File(System.getProperty("user.dir"));
            JTFTools.dumpZip(string + "/", file, zipOutputStream, zipOutputStream2, true, jProgressBar);
            zipOutputStream2.close();
            zipOutputStream.finish();
            zipOutputStream.flush();
            JTFTools.padBase64OutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    private static void dumpZip(String string, File file, ZipOutputStream zipOutputStream, ZipOutputStream zipOutputStream2, boolean bl, JProgressBar jProgressBar) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(jProgressBar)) {
            return;
        }
        String string2 = file.getName();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (!bl) {
                string = string + string2 + "/";
            }
            for (int i = 0; i < stringArray.length; ++i) {
                JTFTools.dumpZip(string, new File(file, stringArray[i]), zipOutputStream, zipOutputStream2, false, jProgressBar);
            }
        } else if (JTFTools.isSubmitComponent(string2)) {
            String string3 = string + string2;
            ZipEntry zipEntry = new ZipEntry(string3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            if (zipOutputStream2 != null) {
                zipOutputStream2.putNextEntry(zipEntry);
                JTFTools.copyBytes(bufferedInputStream, zipOutputStream2, file.length());
                zipOutputStream2.closeEntry();
                ((InputStream)bufferedInputStream).close();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            zipOutputStream.putNextEntry(zipEntry);
            JTFTools.copyBytes(bufferedInputStream, zipOutputStream, file.length());
            zipOutputStream.closeEntry();
            ((InputStream)bufferedInputStream).close();
            if (jProgressBar != null) {
                jProgressBar.setValue(jProgressBar.getValue() + 1);
            }
        }
    }

    private static boolean isSubmitComponent(String string) {
        for (int i = 0; i < SUBMIT_EXTENSIONS.length; ++i) {
            if (!string.endsWith(SUBMIT_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    private static SubmitOptions getOptions(Program program) {
        SubmitOptions submitOptions = optionsTable.get(program);
        if (submitOptions == null) {
            submitOptions = new SubmitOptions(program);
            optionsTable.put(program, submitOptions);
        }
        return submitOptions;
    }

    private static boolean nameAppears(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

