/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.graphics.GObject;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import stanford.spl.GInteractor;
import stanford.spl.GTimer;
import stanford.spl.JBECanvas;
import stanford.spl.JBECommand;
import stanford.spl.JBEConsole;
import stanford.spl.JBEFileFilter;
import stanford.spl.JBELabel;
import stanford.spl.JBEWindow;
import stanford.spl.TokenScanner;
import stanford.spl.TopCompound;

public class JavaBackEnd
implements WindowListener,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
ComponentListener,
ChangeListener {
    public static final int DEFAULT_CONSOLE_X = 10;
    public static final int DEFAULT_CONSOLE_Y = 40;
    public static final int DEFAULT_CONSOLE_WIDTH = 500;
    public static final int DEFAULT_CONSOLE_HEIGHT = 250;
    public static final int DEFAULT_GRAPHICS_X = 10;
    public static final int DEFAULT_GRAPHICS_Y = 10;
    public static final int EVENT_SUBTYPE_MASK = 15;
    public static final int ACTION_EVENT = 16;
    public static final int KEY_EVENT = 32;
    public static final int TIMER_EVENT = 64;
    public static final int WINDOW_EVENT = 128;
    public static final int MOUSE_EVENT = 256;
    public static final int CLICK_EVENT = 512;
    public static final int ANY_EVENT = 1008;
    public static final int WINDOW_CLOSED = 129;
    public static final int WINDOW_RESIZED = 130;
    public static final int ACTION_PERFORMED = 17;
    public static final int MOUSE_CLICKED = 257;
    public static final int MOUSE_PRESSED = 258;
    public static final int MOUSE_RELEASED = 259;
    public static final int MOUSE_MOVED = 260;
    public static final int MOUSE_DRAGGED = 261;
    public static final int KEY_PRESSED = 33;
    public static final int KEY_RELEASED = 34;
    public static final int KEY_TYPED = 35;
    public static final int TIMER_TICKED = 65;
    public static final int SHIFT_DOWN = 1;
    public static final int CTRL_DOWN = 2;
    public static final int META_DOWN = 4;
    public static final int ALT_DOWN = 8;
    public static final int ALT_GRAPH_DOWN = 16;
    public static final int BUTTON1_DOWN = 32;
    public static final int BUTTON2_DOWN = 64;
    public static final int BUTTON3_DOWN = 128;
    private String appName;
    private String exec;
    private JBEConsole console;
    private JFrame consoleFrame;
    private int consoleX = 10;
    private int consoleY = 40;
    private int consoleWidth = 500;
    private int consoleHeight = 250;
    private HashMap<String, JBECommand> cmdTable;
    private HashMap<String, JBEWindow> windowTable;
    private HashMap<String, GObject> gobjTable;
    private HashMap<String, GTimer> timerTable;
    private HashMap<String, Image> imageTable;
    private HashMap<String, Clip> clipTable;
    private HashMap<String, Clip> clipIdTable;
    private HashMap<JComponent, String> sourceTable;
    private Container empty = JTFTools.createEmptyContainer();
    private int activeWindowCount;
    private int eventMask;
    private Object eventLock = new Object();
    private boolean eventAcknowledged;
    private boolean eventPending;

    public static void main(String[] stringArray) {
        new JavaBackEnd().run(stringArray);
    }

    public void run(String[] stringArray) {
        this.processArguments(stringArray);
        this.initSystemProperties();
        this.cmdTable = JBECommand.createCommandTable();
        this.imageTable = new HashMap();
        this.windowTable = new HashMap();
        this.gobjTable = new HashMap();
        this.timerTable = new HashMap();
        this.clipTable = new HashMap();
        this.clipIdTable = new HashMap();
        this.sourceTable = new HashMap();
        this.eventMask = 0;
        this.eventAcknowledged = false;
        this.eventPending = false;
        this.activeWindowCount = 0;
        this.console = new JBEConsole();
        if (this.exec != null) {
            try {
                Process process = Runtime.getRuntime().exec(this.exec);
                System.setIn(process.getInputStream());
                System.setOut(new PrintStream(process.getOutputStream(), true));
            }
            catch (IOException iOException) {
                System.err.println("Can't exec process");
            }
        }
        this.commandLoop();
    }

    protected void createWindow(String string, int n, int n2, TopCompound topCompound) {
        JBEWindow jBEWindow = new JBEWindow(this, string, this.appName, n, n2);
        this.windowTable.put(string, jBEWindow);
        this.consoleWidth = n;
        this.consoleY = 50 + n2;
        jBEWindow.pack();
        jBEWindow.setLocation(10, 10);
        jBEWindow.getCanvas().initOffscreenImage();
        jBEWindow.getCanvas().setTopCompound(topCompound);
        ++this.activeWindowCount;
        jBEWindow.setResizable(false);
        jBEWindow.setVisible(true);
        this.waitForWindowActive(jBEWindow);
    }

    protected void deleteWindow(String string) {
        this.windowTable.remove(string);
    }

    protected void defineGObject(String string, GObject gObject) {
        this.gobjTable.put(string, gObject);
    }

    protected void defineSource(JComponent jComponent, String string) {
        this.sourceTable.put(jComponent, string);
    }

    protected void deleteGObject(String string) {
        this.gobjTable.remove(string);
    }

    protected String getSourceId(JComponent jComponent) {
        return this.sourceTable.get(jComponent);
    }

    protected GObject getGObject(String string) {
        return this.gobjTable.get(string);
    }

    protected JComponent getInteractor(GObject gObject) {
        if (gObject instanceof GInteractor) {
            return ((GInteractor)gObject).getInteractor();
        }
        if (gObject instanceof JBELabel) {
            return ((JBELabel)gObject).getInteractor();
        }
        return null;
    }

    protected JBEWindow getWindow(String string) {
        return this.windowTable.get(string);
    }

    protected void clearConsole() {
        this.console.clear();
    }

    protected void setConsoleFont(String string) {
        this.console.setFont(JTFTools.decodeFont(string));
    }

    protected void setConsoleSize(int n, int n2) {
        this.consoleWidth = n;
        this.consoleHeight = n2;
    }

    protected String getConsole() {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        return this.console.readLine();
    }

    protected void putConsole(String string) {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        this.console.print(string);
    }

    protected void endLineConsole() {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        this.console.println();
    }

    protected double getEventTime() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void println(String string) {
        Object object = this.eventLock;
        synchronized (object) {
            System.out.println(string);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeEvent() {
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.eventAcknowledged) {
                System.out.println("result:ack");
                System.out.flush();
                this.eventAcknowledged = true;
                this.eventPending = false;
            } else {
                this.eventPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getNextEvent(int n) {
        Object object = this.eventLock;
        synchronized (object) {
            this.eventAcknowledged = false;
            this.eventPending = false;
            this.acknowledgeEvent();
            this.eventMask = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForEvent(int n) {
        Object object = this.eventLock;
        synchronized (object) {
            this.eventAcknowledged = false;
            if (this.eventPending) {
                this.acknowledgeEvent();
            }
            this.eventMask = n;
        }
    }

    private void showConsole() {
        this.console.setPreferredSize(this.consoleWidth, this.consoleHeight);
        this.consoleFrame = new JFrame("Console");
        this.consoleFrame.setLayout(new BorderLayout());
        this.consoleFrame.add(this.console);
        this.consoleFrame.pack();
        this.consoleFrame.setLocation(this.consoleX, this.consoleY);
        this.consoleFrame.addWindowListener(this);
        this.consoleFrame.setVisible(true);
        this.waitForWindowActive(this.consoleFrame);
        ++this.activeWindowCount;
    }

    protected void createSound(String string, String string2) {
        Clip clip = this.getClip(string2);
        this.clipIdTable.put(string, clip);
    }

    protected void deleteSound(String string) {
        this.clipIdTable.remove(string);
    }

    protected void playSound(String string) {
        Clip clip = this.clipIdTable.get(string);
        if (clip != null) {
            clip.stop();
            clip.setFramePosition(0);
            clip.start();
        }
    }

    protected void createTimer(String string, double d) {
        GTimer gTimer = new GTimer(string, d);
        gTimer.addActionListener(this);
        this.timerTable.put(string, gTimer);
    }

    protected void deleteTimer(String string) {
        GTimer gTimer = this.timerTable.get(string);
        if (gTimer != null) {
            gTimer.stop();
        }
        this.timerTable.remove(string);
    }

    protected void startTimer(String string) {
        GTimer gTimer = this.timerTable.get(string);
        if (gTimer != null) {
            gTimer.start();
        }
    }

    protected void stopTimer(String string) {
        GTimer gTimer = this.timerTable.get(string);
        if (gTimer != null) {
            gTimer.stop();
        }
    }

    private int convertModifiers(int n) {
        int n2 = 0;
        if ((n & 0x40) != 0) {
            n2 |= 1;
        }
        if ((n & 0x80) != 0) {
            n2 |= 2;
        }
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0x200) != 0) {
            n2 |= 8;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 0x80;
        }
        return n2;
    }

    protected String openFileDialog(String string, String string2, String string3) {
        JBEFileFilter jBEFileFilter = new JBEFileFilter(string3);
        JFileChooser jFileChooser = new JFileChooser(jBEFileFilter.getDirectory());
        jFileChooser.setFileFilter(jBEFileFilter);
        jFileChooser.setDialogTitle(string);
        int n = 0;
        if (string2.equalsIgnoreCase("load")) {
            n = jFileChooser.showOpenDialog(null);
        } else if (string2.equalsIgnoreCase("save")) {
            n = jFileChooser.showSaveDialog(null);
        } else {
            return "";
        }
        if (n == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Object object2 = this.eventLock;
        synchronized (object2) {
            String string;
            GInteractor gInteractor;
            String string2;
            if (object instanceof GTimer) {
                if ((this.eventMask & 0x40) != 0) {
                    GTimer gTimer = (GTimer)actionEvent.getSource();
                    System.out.print("event:timerTicked");
                    System.out.print("(\"" + gTimer.getId() + "\", " + this.getEventTime());
                    System.out.println(")");
                    System.out.flush();
                    this.acknowledgeEvent();
                }
            } else if ((this.eventMask & 0x10) != 0 && !(string2 = (gInteractor = (GInteractor)this.getGObject(string = this.getSourceId((JComponent)object))).getActionCommand()).isEmpty()) {
                System.out.print("event:actionPerformed");
                System.out.print("(\"" + string + "\", \"" + string2 + "\", " + this.getEventTime());
                System.out.println(")");
                System.out.flush();
                this.acknowledgeEvent();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyPressed", keyEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyReleased", keyEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyTyped", keyEvent);
            this.acknowledgeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printEvent(String string, KeyEvent keyEvent) {
        JBECanvas jBECanvas = (JBECanvas)keyEvent.getSource();
        Object object = this.eventLock;
        synchronized (object) {
            System.out.print("event:" + string);
            System.out.print("(\"" + jBECanvas.getWindowId() + "\", " + this.getEventTime());
            System.out.print(", " + this.convertModifiers(keyEvent.getModifiersEx()));
            System.out.print(", " + keyEvent.getKeyChar());
            System.out.println(", " + keyEvent.getKeyCode() + ")");
            System.out.flush();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).requestFocus();
        if ((this.eventMask & 0x300) != 0) {
            this.printEvent("mouseClicked", mouseEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mousePressed", mouseEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseReleased", mouseEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseMoved", mouseEvent);
            this.acknowledgeEvent();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseDragged", mouseEvent);
            this.acknowledgeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printEvent(String string, MouseEvent mouseEvent) {
        JBECanvas jBECanvas = (JBECanvas)mouseEvent.getSource();
        Object object = this.eventLock;
        synchronized (object) {
            System.out.print("event:" + string);
            System.out.print("(\"" + jBECanvas.getWindowId() + "\", " + this.getEventTime());
            System.out.print(", " + this.convertModifiers(mouseEvent.getModifiersEx()));
            System.out.println(", " + mouseEvent.getX() + ", " + mouseEvent.getY() + ")");
            System.out.flush();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.windowClosing(windowEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Object object;
        if (windowEvent.getSource() != this.consoleFrame) {
            object = (JBEWindow)windowEvent.getSource();
            Object object2 = this.eventLock;
            synchronized (object2) {
                System.out.print("event:windowClosed");
                System.out.print("(\"" + ((JBEWindow)object).getWindowId());
                System.out.print("\", " + this.getEventTime());
                System.out.println(")");
                System.out.flush();
                this.acknowledgeEvent();
            }
            this.windowTable.remove(((JBEWindow)object).getWindowId());
        }
        --this.activeWindowCount;
        if (this.activeWindowCount == 0) {
            object = this.eventLock;
            synchronized (object) {
                System.out.println("event:lastWindowGWindow_closed()");
                System.out.flush();
                this.acknowledgeEvent();
            }
            System.exit(0);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowOpened(WindowEvent windowEvent) {
        JFrame jFrame;
        JFrame jFrame2 = jFrame = (JFrame)windowEvent.getSource();
        synchronized (jFrame2) {
            jFrame.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWindowActive(JFrame jFrame) {
        JFrame jFrame2 = jFrame;
        synchronized (jFrame2) {
            while (!jFrame.isShowing()) {
                try {
                    jFrame.wait();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        Object object2 = this.eventLock;
        synchronized (object2) {
            String string;
            GInteractor gInteractor;
            String string2;
            if ((this.eventMask & 0x10) != 0 && !(string2 = (gInteractor = (GInteractor)this.getGObject(string = this.getSourceId((JComponent)object))).getActionCommand()).isEmpty()) {
                System.out.print("event:actionPerformed");
                System.out.print("(\"" + string + "\", \"" + string2 + "\", " + this.getEventTime());
                System.out.println(")");
                System.out.flush();
                this.acknowledgeEvent();
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if ((this.eventMask & 0x80) != 0) {
            JBECanvas jBECanvas = (JBECanvas)componentEvent.getSource();
            Object object = this.eventLock;
            synchronized (object) {
                System.out.print("event:windowResized");
                System.out.print("(\"" + jBECanvas.getWindowId());
                System.out.print("\", " + this.getEventTime());
                System.out.println(")");
                System.out.flush();
                this.acknowledgeEvent();
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private void commandLoop() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        TokenScanner tokenScanner = new TokenScanner();
        tokenScanner.ignoreWhitespace();
        tokenScanner.scanNumbers();
        tokenScanner.scanStrings();
        tokenScanner.addWordCharacters(".");
        while (true) {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    tokenScanner.setInput(string);
                    String string2 = tokenScanner.nextToken();
                    JBECommand jBECommand = this.cmdTable.get(string2);
                    if (jBECommand == null) continue;
                    jBECommand.execute(tokenScanner, this);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.err.println("Unexpected error: " + exception.getMessage());
                continue;
            }
            break;
        }
    }

    private void processArguments(String[] stringArray) {
        this.appName = "JBE";
        this.exec = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-exec")) {
                    this.exec = stringArray[++i];
                    continue;
                }
                System.err.println("Error: Unrecognized option " + string);
                continue;
            }
            this.appName = string;
        }
    }

    private void initSystemProperties() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.appName);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Image getImage(String string) {
        Serializable serializable;
        Image image = this.imageTable.get(string);
        if (image != null) {
            return image;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (string.startsWith("http:")) {
            try {
                image = toolkit.getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ErrorException("loadImage: Malformed URL");
            }
        } else {
            serializable = new File(string);
            if (!(((File)serializable).exists() || string.startsWith("/") || string.startsWith("."))) {
                serializable = new File("images/" + string);
            }
            if (!((File)serializable).exists()) {
                throw new ErrorException("loadImage: File not found");
            }
            image = toolkit.getImage(((File)serializable).getAbsolutePath());
        }
        if (image == null) {
            throw new ErrorException("loadImage: File not found");
        }
        serializable = new MediaTracker(this.empty);
        ((MediaTracker)serializable).addImage(image, 0);
        try {
            ((MediaTracker)serializable).waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            throw new ErrorException("loadImage: Loading interrupted");
        }
        this.imageTable.put(string, image);
        return image;
    }

    protected Clip getClip(String string) {
        Clip clip = this.clipTable.get(string);
        if (clip != null) {
            return clip;
        }
        try {
            clip = AudioSystem.getClip();
            File file = new File(string);
            if (!(file.exists() || string.startsWith("/") || string.startsWith("."))) {
                file = new File("sounds/" + string);
            }
            if (!file.exists()) {
                throw new ErrorException("createClip: File not found");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(fileInputStream);
            clip.open(audioInputStream);
        }
        catch (IOException iOException) {
            throw new ErrorException("getClip: File not found");
        }
        catch (Exception exception) {
            throw new ErrorException("getClip: " + exception);
        }
        this.clipTable.put(string, clip);
        return clip;
    }
}

