/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GPoint;
import java.awt.Rectangle;
import java.io.Serializable;

public class GRectangle
implements Serializable {
    private double xc;
    private double yc;
    private double width;
    private double height;
    static final long serialVersionUID = 21L;

    public GRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GRectangle(double d, double d2, double d3, double d4) {
        this.xc = d;
        this.yc = d2;
        this.width = d3;
        this.height = d4;
    }

    public GRectangle(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GRectangle(GPoint gPoint, GDimension gDimension) {
        this(gPoint.getX(), gPoint.getY(), gDimension.getWidth(), gDimension.getHeight());
    }

    public GRectangle(GPoint gPoint) {
        this(gPoint.getX(), gPoint.getY(), 0.0, 0.0);
    }

    public GRectangle(GDimension gDimension) {
        this(0.0, 0.0, gDimension.getWidth(), gDimension.getHeight());
    }

    public GRectangle(GRectangle gRectangle) {
        this(gRectangle.xc, gRectangle.yc, gRectangle.width, gRectangle.height);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.xc = d;
        this.yc = d2;
        this.width = d3;
        this.height = d4;
    }

    public void setBounds(GPoint gPoint, GDimension gDimension) {
        this.setBounds(gPoint.getX(), gPoint.getY(), gDimension.getWidth(), gDimension.getHeight());
    }

    public void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.xc, gRectangle.yc, gRectangle.width, gRectangle.height);
    }

    public GRectangle getBounds() {
        return new GRectangle(this);
    }

    public void setLocation(double d, double d2) {
        this.xc = d;
        this.yc = d2;
    }

    public void setLocation(GPoint gPoint) {
        this.setLocation(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public void translate(double d, double d2) {
        this.xc += d;
        this.yc += d2;
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.width, this.height);
    }

    public void grow(double d, double d2) {
        this.xc -= d;
        this.yc -= d2;
        this.width += 2.0 * d;
        this.height += 2.0 * d2;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean contains(double d, double d2) {
        return d >= this.xc && d2 >= this.yc && d < this.xc + this.width && d2 < this.yc + this.height;
    }

    public boolean contains(GPoint gPoint) {
        return this.contains(gPoint.getX(), gPoint.getY());
    }

    public boolean intersects(GRectangle gRectangle) {
        GRectangle gRectangle2 = this;
        if (gRectangle2.xc > gRectangle.xc + gRectangle.width) {
            return false;
        }
        if (gRectangle2.yc > gRectangle.yc + gRectangle.height) {
            return false;
        }
        if (gRectangle.xc > gRectangle2.xc + gRectangle2.width) {
            return false;
        }
        return !(gRectangle.yc > gRectangle2.yc + gRectangle2.height);
    }

    public GRectangle intersection(GRectangle gRectangle) {
        GRectangle gRectangle2 = this;
        double d = Math.max(gRectangle2.xc, gRectangle.xc);
        double d2 = Math.max(gRectangle2.yc, gRectangle.yc);
        double d3 = Math.min(gRectangle2.xc + gRectangle2.width, gRectangle.xc + gRectangle.width);
        double d4 = Math.min(gRectangle2.yc + gRectangle2.height, gRectangle.yc + gRectangle.height);
        return new GRectangle(d, d2, d3 - d, d4 - d2);
    }

    public GRectangle union(GRectangle gRectangle) {
        if (this.isEmpty()) {
            return new GRectangle(gRectangle);
        }
        if (gRectangle.isEmpty()) {
            return new GRectangle(this);
        }
        GRectangle gRectangle2 = this;
        double d = Math.min(gRectangle2.xc, gRectangle.xc);
        double d2 = Math.min(gRectangle2.yc, gRectangle.yc);
        double d3 = Math.max(gRectangle2.xc + gRectangle2.width, gRectangle.xc + gRectangle.width);
        double d4 = Math.max(gRectangle2.yc + gRectangle2.height, gRectangle.yc + gRectangle.height);
        return new GRectangle(d, d2, d3 - d, d4 - d2);
    }

    public void add(GRectangle gRectangle) {
        if (gRectangle.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(gRectangle);
            return;
        }
        double d = Math.max(this.xc + this.width, gRectangle.xc + gRectangle.width);
        double d2 = Math.max(this.yc + this.height, gRectangle.yc + gRectangle.height);
        this.xc = Math.min(gRectangle.xc, this.xc);
        this.yc = Math.min(gRectangle.yc, this.yc);
        this.width = d - this.xc;
        this.height = d2 - this.yc;
    }

    public void add(double d, double d2) {
        if (this.isEmpty()) {
            this.setBounds(d, d2, 0.0, 0.0);
            return;
        }
        double d3 = Math.max(d + this.width, d);
        double d4 = Math.max(d2 + this.height, d2);
        this.xc = Math.min(d, this.xc);
        this.yc = Math.min(d2, this.yc);
        this.width = d3 - this.xc;
        this.height = d4 - this.yc;
    }

    public Rectangle toRectangle() {
        return new Rectangle(GMath.round(this.xc), GMath.round(this.yc), GMath.round(this.width), GMath.round(this.height));
    }

    public int hashCode() {
        int n = new Float((float)this.xc).hashCode();
        n = 37 * n ^ new Float((float)this.yc).hashCode();
        n = 37 * n ^ new Float((float)this.width).hashCode();
        n = 37 * n ^ new Float((float)this.height).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GRectangle)) {
            return false;
        }
        GRectangle gRectangle = (GRectangle)object;
        if ((float)this.xc != (float)gRectangle.xc) {
            return false;
        }
        if ((float)this.yc != (float)gRectangle.yc) {
            return false;
        }
        if ((float)this.width != (float)gRectangle.width) {
            return false;
        }
        return (float)this.height == (float)gRectangle.height;
    }

    public String toString() {
        return "[" + (float)this.xc + ", " + (float)this.yc + ", " + (float)this.width + "x" + (float)this.height + "]";
    }
}

