/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.graphics.GCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import stanford.spl.TopCompound;

public class JBECanvas
extends GCanvas {
    private static final long serialVersionUID = 1L;
    private String windowId;
    private TopCompound topCompound;
    private Graphics2D osg;
    private Image offscreenImage;
    private int preferredWidth;
    private int preferredHeight;

    public JBECanvas(String paramString, int paramInt1, int paramInt2) {
        this.windowId = paramString;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(false);
        this.setLayout(null);
        this.preferredWidth = paramInt1;
        this.preferredHeight = paramInt2;
    }

    protected Graphics2D getOSG() {
        return this.osg;
    }

    protected void setTopCompound(TopCompound paramTopCompound) {
        this.topCompound = paramTopCompound;
        paramTopCompound.setCanvas(this);
        paramTopCompound.setParent(this);
    }

    protected TopCompound getTopCompound() {
        return this.topCompound;
    }

    protected void initOffscreenImage() {
        Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.offscreenImage = this.createImage(localDimension.width, localDimension.height);
        this.osg = (Graphics2D)this.offscreenImage.getGraphics();
        this.osg.setColor(this.getBackground());
        this.osg.fillRect(0, 0, localDimension.width, localDimension.height);
        this.osg.setColor(this.getForeground());
    }

    public String getWindowId() {
        return this.windowId;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    public void setPreferredSize(Dimension d) {
        this.preferredWidth = d.width;
        this.preferredHeight = d.height;
    }

    public void clear() {
        Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.osg.setColor(Color.WHITE);
        this.osg.fillRect(0, 0, localDimension.width, localDimension.height);
        this.osg.setColor(Color.BLACK);
        this.repaint();
    }

    public void draw(Shape paramShape) {
        this.osg.draw(paramShape);
        this.repaint();
    }

    public void fill(Shape paramShape) {
        this.osg.fill(paramShape);
        this.repaint();
    }

    public void drawRect(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        Rectangle2D.Double localDouble = new Rectangle2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void fillRect(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        Rectangle2D.Double localDouble = new Rectangle2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4);
        this.osg.fill(localDouble);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void drawOval(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        Ellipse2D.Double localDouble = new Ellipse2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void fillOval(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        Ellipse2D.Double localDouble = new Ellipse2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4);
        this.osg.fill(localDouble);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void drawArc(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4, double paramDouble5, double paramDouble6) {
        Arc2D.Double localDouble = new Arc2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4, paramDouble5, paramDouble6, 0);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void fillArc(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4, double paramDouble5, double paramDouble6) {
        Arc2D.Double localDouble = new Arc2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4, paramDouble5, paramDouble6, 2);
        this.osg.fill(localDouble);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void drawLine(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        Line2D.Double localDouble = new Line2D.Double(paramDouble1, paramDouble2, paramDouble3, paramDouble4);
        this.osg.draw(localDouble);
        this.repaint();
    }

    public void setColor(int paramInt) {
        this.osg.setColor(new Color(paramInt));
    }

    public void paint(Graphics paramGraphics) {
        paramGraphics.drawImage(this.offscreenImage, 0, 0, this);
        this.topCompound.paint(paramGraphics);
        super.paint(paramGraphics);
    }
}

