/*
 * CS 106X, Marty Stepp
 *
 * This file provides the implementation of the bodies of the member functions,
 * constructor, and overloaded operators for the BankAccount class
 * that is declared in BankAccount.h.
 * 
 * Invariant: balance >= 0.00
 */

#include "BankAccount.h"
#include <iomanip>         // for setprecision, fixed in << operator

// constructor implementation
BankAccount::BankAccount(string n, double b) {
    name = n;
    balance = b;
    checkAccountState();
}

// method implementations
void BankAccount::deposit(double amount) {
    if (amount < 0) {
        throw "Illegal negative amount";
    }
    balance += amount;
    checkAccountState();
}

double BankAccount::getBalance() {
    return balance;
}

string BankAccount::getName() {
    return name;
}

void BankAccount::transfer(BankAccount& person, double amount) {
    if (amount < 0) {
        throw "Illegal negative amount";
    }
    if (balance >= amount) {
        withdraw(amount);
        person.deposit(amount);
    }
}

void BankAccount::withdraw(double amount) {
    if (amount < 0) {
        throw "Illegal negative amount";
    }
    balance -= amount;
    checkAccountState();
}

void BankAccount::checkAccountState() {
    if (name.length() == 0 || balance < 0.00) {
        throw "Illegal account state";
    }
}

bool operator ==(BankAccount& ba1, BankAccount& ba2) {
    return (ba1.getName() == ba2.getName() &&
            ba1.getBalance() == ba2.getBalance());
}

bool operator !=(BankAccount& ba1, BankAccount& ba2) {
    return !(ba1 == ba2);
}

ostream& operator <<(ostream& out, BankAccount& ba) {
    out << ba.getName() 
         << ", $" << fixed << setprecision(2) << ba.getBalance();
    return out;
}
