/*
 * CS 106X, Marty Stepp
 * This file declares a class named BankAccount.
 * Each BankAccount object represents information about a single
 * person's bank account, such as their name and balance.
 * Implementation of each class member is found in BankAccount.cpp.
 */

#ifndef _bankaccount_h
#define _bankaccount_h

#include <iostream>
#include <string>
using namespace std;

class BankAccount {
public:
    // constructor - initializes newly created objects
    BankAccount(string n, double b = 0.0);
    
    // member functions - behavior of each object
    void deposit(double amount);
    double getBalance();
    string getName();
    void transfer(BankAccount& person, double amount);
    void withdraw(double amount);

private:
    // member variables - data found in each object
    string name;
    double balance;

    // private helper method for verifying object state
    void checkAccountState();
};

// overloaded operators for testing for equality and printing
bool operator ==(BankAccount& ba1, BankAccount& ba2);
bool operator !=(BankAccount& ba1, BankAccount& ba2);
ostream& operator <<(ostream& out, BankAccount& ba);

#endif 
