/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import stanford.spl.SPLWindowSettings;

public class AutograderInput
extends Observable
implements ActionListener {
    private static final int MIN_WIDTH = 75;
    private static AutograderInput instance;
    private JFrame frame = new JFrame();
    private JPanel currentCategory;
    private Map<String, JComponent> components;

    public static synchronized AutograderInput getInstance() {
        if (instance == null) {
            instance = new AutograderInput();
        }
        return instance;
    }

    public AutograderInput() {
        this.frame.setTitle("Autograder Input");
        this.frame.setVisible(false);
        Box box = Box.createVerticalBox();
        this.frame.setContentPane(box);
        this.components = new HashMap<String, JComponent>();
        SPLWindowSettings.loadWindowLocation(this.frame);
        SPLWindowSettings.saveWindowLocation(this.frame);
    }

    public void addBlank() {
        this.addButton("");
    }

    public void addButton(String text) {
        this.addButton(text, text);
    }

    public void addButton(String text, String input) {
        if (this.currentCategory == null) {
            this.currentCategory = new JPanel(new FlowLayout(0));
            this.frame.add(this.currentCategory);
        }
        if (text.length() == 0) {
            this.currentCategory.add(new JPanel());
        } else {
            if (!input.endsWith("\n")) {
                input = String.valueOf(input) + "\n";
            }
            JButton button = new JButton(text);
            button.setActionCommand(input);
            button.addActionListener(this);
            this.currentCategory.add(button);
            this.components.put(text, button);
        }
        this.checkVisibility();
    }

    public void addCategory(String name) {
        this.currentCategory = new JPanel(new FlowLayout(0));
        this.currentCategory.setBorder(BorderFactory.createTitledBorder(name));
        this.frame.add(this.currentCategory);
        this.components.put(name, this.currentCategory);
        this.checkVisibility();
    }

    public void actionPerformed(ActionEvent event) {
        this.setChanged();
        this.notifyObservers(event.getActionCommand());
    }

    public boolean isEmpty() {
        return this.buttonCount() == 0;
    }

    public int buttonCount() {
        return this.frame.getComponentCount();
    }

    public int getColumns() {
        return 1;
    }

    public void removeButton(String text) {
        JComponent button = this.components.get(text);
        if (button != null) {
            this.components.remove(text);
            this.frame.remove(button);
            this.checkVisibility();
        }
    }

    public void removeCategory(String name) {
        JComponent category = this.components.get(name);
        if (category != null) {
            this.components.remove(name);
            this.frame.remove(category);
            this.checkVisibility();
        }
    }

    public void setColumns(int columns) {
        this.checkVisibility();
    }

    private void checkVisibility() {
        this.frame.validate();
        this.frame.pack();
        if (this.frame.getWidth() < 75) {
            this.frame.setSize(75, this.frame.getHeight());
        }
        this.frame.setVisible(!this.isEmpty());
    }
}

