/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> ArrayList<T> asList(T ... strings) {
        ArrayList<T> list = new ArrayList<T>(strings.length + 1);
        T[] TArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            T s = TArray[n2];
            list.add(s);
            ++n2;
        }
        return list;
    }

    public static <T> List<T> asList(Enumeration<T> enu) {
        ArrayList<T> list = new ArrayList<T>();
        while (enu != null && enu.hasMoreElements()) {
            list.add(enu.nextElement());
        }
        return list;
    }

    public static <T> List<T> asList(Iterator<T> itr) {
        ArrayList<T> list = new ArrayList<T>();
        while (itr != null && itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        if (keys == null || values == null) {
            return map;
        }
        int i = 0;
        int len = Math.min(keys.length, values.length);
        while (i < len) {
            map.put(keys[i], values[i]);
            ++i;
        }
        return map;
    }

    public static <K, V> Map<K, V> asMap(List<K> keys, List<V> values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        if (keys == null || values == null) {
            return map;
        }
        int i = 0;
        int len = Math.min(keys.size(), values.size());
        while (i < len) {
            map.put(keys.get(i), values.get(i));
            ++i;
        }
        return map;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> asMapSorted(K[] keys, V[] values) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        if (keys == null || values == null) {
            return map;
        }
        int i = 0;
        int len = Math.min(keys.length, values.length);
        while (i < len) {
            map.put(keys[i], values[i]);
            ++i;
        }
        return map;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> asMapSorted(List<K> keys, List<V> values) {
        TreeMap<Comparable, V> map = new TreeMap<Comparable, V>();
        if (keys == null || values == null) {
            return map;
        }
        int i = 0;
        int len = Math.min(keys.size(), values.size());
        while (i < len) {
            map.put((Comparable)keys.get(i), values.get(i));
            ++i;
        }
        return map;
    }

    public static <K> Set<K> asSet(K value) {
        LinkedHashSet<K> set = new LinkedHashSet<K>();
        if (value != null) {
            set.add(value);
        }
        return set;
    }

    public static <K> Set<K> asSet(K ... values) {
        LinkedHashSet<K> set = new LinkedHashSet<K>();
        if (values == null) {
            return set;
        }
        K[] KArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            K value = KArray[n2];
            set.add(value);
            ++n2;
        }
        return set;
    }

    public static <K extends Comparable<K>> Set<K> asSetSorted(K ... values) {
        TreeSet<K> set = new TreeSet<K>();
        K[] KArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            K value = KArray[n2];
            set.add(value);
            ++n2;
        }
        return set;
    }

    public static String join(Collection<?> c) {
        return CollectionUtils.join(c, ", ");
    }

    public static String join(Collection<?> c, String separator) {
        if (c == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Object o : c) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(o);
            ++i;
        }
        return result.toString();
    }

    public static String join(Map<?, ?> map) {
        return CollectionUtils.join(map, "=", ", ");
    }

    public static String join(Map<?, ?> map, String kvSeparator, String elementSeparator) {
        if (map == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (i > 0) {
                result.append(elementSeparator);
            }
            result.append(entry.getKey());
            result.append(kvSeparator);
            result.append(entry.getValue());
            ++i;
        }
        return result.toString();
    }
}

