/**************************************************
 * gostanford.cpp
 *
 * Cynthia Lee (c) 2013
 *
 * This program simulates the sports fans' cheer
 * of "Go Stanford!", in which sections of the
 * bleachers take turns yelling "Go!" and "Stanford!"
 *
 * It illustrates the principle of mutual recursion,
 * or two functions that call each other.
 ***************************************************/

#include<iostream>
#include "console.h"
#include "simpio.h"
using namespace std;

void go(int n);
void stanford(int n);

static const int NUM_REPETITIONS = 10;

/* main()
 *
 * Asks the user how many times to repeat the cheer,
 * then performs the cheer.
 */
int main(){
    int repetitions = getInteger("Enter a number of times to repeat:");
    go(repetitions);
    getLine("Press enter to quit.");
    return 0;
}

/* go()
 *
 * Prints "Go!" and then calls stanford() for
 * the second half of the cheer.
 *
 * repetitions - the (remaining) number of times
 *               to repeat the cheer
 */
void go(int repetitions) {
    if (repetitions == 0) return;
    cout << "Go!" << endl;
    stanford(repetitions-1);
}

/* stanford()
 *
 * Prints "Stanford!" and then calls go() to
 * continue repeating the cheer.
 *
 * repetitions - the (remaining) number of times
 *               to repeat the cheer
 */
void stanford(int repetitions) {
    cout << "Stanford!" << endl;
    go(repetitions);
}
