/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;

public class GuiUtils2 {
    public static final String SETTINGS_FILENAME = "autograder-window-settings.sav";
    private static Properties props = new Properties();
    private static String tempDir = System.getProperty("java.io.tmpdir");

    private GuiUtils2() {
    }

    public static JButton addButton(ActionListener listener, String text, char mnemonic, Container container) {
        JButton button = new JButton(text);
        if (mnemonic != '\u0000' && mnemonic != ' ') {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        container.add(button);
        return button;
    }

    public static JButton addButton(ActionListener listener, String text, String actionCommand, char mnemonic, Container container) {
        JButton button = new JButton(text);
        button.setActionCommand(actionCommand);
        if (mnemonic != '\u0000' && mnemonic != ' ') {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        container.add(button);
        return button;
    }

    public static JButton createButton(ActionListener listener, String text, char mnemonic) {
        JButton button = new JButton(text);
        if (mnemonic != '\u0000' && mnemonic != ' ') {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        return button;
    }

    public static JButton createButton(ActionListener listener, String text, String actionCommand, char mnemonic) {
        JButton button = new JButton(text);
        button.setActionCommand(actionCommand);
        if (mnemonic != '\u0000' && mnemonic != ' ') {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        return button;
    }

    public static JLabel createLabel(String text, int width) {
        return GuiUtils2.createLabel(text, width, false);
    }

    public static JLabel createLabel(String text, int width, boolean rightAligned) {
        JLabel label = new JLabel(text);
        Dimension size = label.getPreferredSize();
        if (size.width < width) {
            size.width = width;
        }
        if (rightAligned) {
            label.setHorizontalAlignment(4);
        }
        label.setPreferredSize(size);
        return label;
    }

    public static void rememberWindowLocation(Frame window) {
        window.addComponentListener(new WindowSettingsComponentAdapter());
        GuiUtils2.loadWindowLocation(window);
    }

    public static void forgetWindowLocation(Frame window) {
        ComponentListener[] componentListenerArray = window.getComponentListeners();
        int n = componentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener listener = componentListenerArray[n2];
            if (listener instanceof WindowSettingsComponentAdapter) {
                window.removeComponentListener(listener);
                String title = window.getTitle();
                props.remove(String.valueOf(title) + "-x");
                props.remove(String.valueOf(title) + "-y");
                props.remove(String.valueOf(title) + "-w");
                props.remove(String.valueOf(title) + "-h");
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWindowLocation(Frame window) {
        Properties properties = props;
        synchronized (properties) {
            try {
                String settingsFile = String.valueOf(tempDir) + "/" + SETTINGS_FILENAME;
                if (new File(settingsFile).exists()) {
                    FileInputStream input = new FileInputStream(settingsFile);
                    props.load(input);
                }
            }
            catch (IOException ioe) {
                System.err.println("I/O error trying to load window settings: " + ioe);
            }
            catch (Exception e) {
                System.err.println("Error trying to save window settings: " + e);
            }
        }
        String title = window.getTitle();
        if (props.containsKey(String.valueOf(title) + "-x") && props.containsKey(String.valueOf(title) + "-y")) {
            int x = Integer.parseInt(props.getProperty(String.valueOf(title) + "-x"));
            int y = Integer.parseInt(props.getProperty(String.valueOf(title) + "-y"));
            window.setLocation(x, y);
        }
        if (props.containsKey(String.valueOf(title) + "-w") && props.containsKey(String.valueOf(title) + "-h")) {
            int w = Integer.parseInt(props.getProperty(String.valueOf(title) + "-w"));
            int h = Integer.parseInt(props.getProperty(String.valueOf(title) + "-h"));
            window.setSize(w, h);
        }
    }

    private static class WindowSettingsComponentAdapter
    extends ComponentAdapter {
        private WindowSettingsComponentAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent event) {
            Component component = event.getComponent();
            if (!(component instanceof Frame)) {
                return;
            }
            Frame window = (Frame)component;
            int x = window.getX();
            int y = window.getY();
            int w = window.getWidth();
            int h = window.getHeight();
            Properties properties = props;
            synchronized (properties) {
                props.setProperty(String.valueOf(window.getTitle()) + "-x", String.valueOf(x));
                props.setProperty(String.valueOf(window.getTitle()) + "-y", String.valueOf(y));
                props.setProperty(String.valueOf(window.getTitle()) + "-w", String.valueOf(w));
                props.setProperty(String.valueOf(window.getTitle()) + "-h", String.valueOf(h));
                try {
                    String settingsFile = String.valueOf(tempDir) + "/" + GuiUtils2.SETTINGS_FILENAME;
                    FileOutputStream out = new FileOutputStream(settingsFile);
                    props.store(out, "Stanford Autograder window location settings");
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {
                    System.err.println("I/O error trying to save window settings: " + ioe);
                }
                catch (Exception e) {
                    System.err.println("Error trying to save window settings: " + e);
                }
            }
        }
    }
}

