/**
 * File: mousetest.cpp
 * --------------
 * Demonstrates mouse events.
 *
 * To use the demonstration, start it and then move the mouse around on the display
 * window area (click, hold down the button, release button, move mouse while
 * holding button, etc). The events generated by these actions are printed to the
 * console.
 *
 * Cynthia Lee (c) 2013
 *
 */

#include <iostream>  // for cout
using namespace std;

#include "console.h"
#include "gevents.h"
#include "map.h"
#include "vector.h"
#include "simpio.h"

static const int kDisplayWidth = 10 * 72; // 10 inches
static const int kDisplayHeight = 7 * 72; // 7 inches

int main(){

    bool beSilent = false;
    GWindow window(kDisplayWidth,kDisplayHeight);
    while (true) {
        pause(10);
        GMouseEvent me = getNextEvent(MOUSE_EVENT);
        switch (me.getEventType()) {
        case MOUSE_CLICKED:
            cout << "MOUSE_CLICKED" << endl;
            beSilent = false;
            break;
        case MOUSE_PRESSED:
            cout << "MOUSE_PRESSED" << endl;
            beSilent = false;
            break;
        case MOUSE_RELEASED:
            cout << "MOUSE_RELEASED" << endl;
            beSilent = false;
            break;
        case MOUSE_MOVED:
            cout << "MOUSE_MOVED" << endl;
            beSilent = false;
            break;
        case MOUSE_DRAGGED:
            cout << "MOUSE_DRAGGED" << endl;
            beSilent = false;
            break;
        default:
            if (!beSilent){
                cout << "NULL_EVENT (tried to dequeue from empty queue)" << endl;
                beSilent = true;
            }
            break;
        }
        pause(50);
    }

    return 0;
}
