/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.gui;

import acm.program.Program;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import stanford.cs106.gui.ResizeListener;
import stanford.cs106.io.ResourceUtils;

public class GuiUtils {
    public static final String SETTINGS_FILENAME = "autograder-window-settings.sav";
    private static Properties props = new Properties();
    private static String tempDir = System.getProperty("java.io.tmpdir");

    public static void addKeyListenerRecursive(Component component, KeyListener listener) {
        if (component.isFocusable() || component instanceof Window) {
            component.addKeyListener(listener);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component subcomponent = componentArray[n2];
                GuiUtils.addKeyListenerRecursive(subcomponent, listener);
                ++n2;
            }
        }
    }

    public static void addResizeListener(Program program) {
        if (!(program instanceof ResizeListener)) {
            throw new ClassCastException("Your program class must implement the ResizeListener interface.");
        }
        final ResizeListener listener = (ResizeListener)((Object)program);
        program.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                listener.componentResized(event);
            }
        });
    }

    public static void centerWindow(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - window.getWidth() / 2, screenSize.height / 2 - window.getHeight() / 2);
    }

    public static JButton createButton(String text, char mnemonic, ActionListener listener) {
        return GuiUtils.createButton(text, null, null, mnemonic, listener);
    }

    public static JButton createButton(String text, String actionCommand, char mnemonic, ActionListener listener) {
        return GuiUtils.createButton(text, actionCommand, null, mnemonic, listener);
    }

    public static JButton createButton(String text, String actionCommand, String icon, char mnemonic, ActionListener listener) {
        JButton button = new JButton(text);
        if (actionCommand == null || actionCommand.isEmpty()) {
            actionCommand = text;
        }
        button.setActionCommand(actionCommand);
        if (icon != null && icon.length() > 0) {
            try {
                if (ResourceUtils.fileExists(icon)) {
                    button.setIcon(new ImageIcon(ResourceUtils.filenameToURL(icon)));
                }
            }
            catch (Exception e) {
                try {
                    button.setIcon(new ImageIcon(ResourceUtils.filenameToURL(icon)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (mnemonic != '\u0000' && mnemonic != ' ') {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        return button;
    }

    public static JComboBox createComboBox(String actionCommand, ActionListener listener, String ... items) {
        JComboBox<String> box = new JComboBox<String>();
        box.setEditable(false);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            box.addItem(item);
            ++n2;
        }
        if (listener != null) {
            box.addActionListener(listener);
            box.setActionCommand(actionCommand);
        }
        return box;
    }

    public static JPanel createPanel(Component ... components) {
        return GuiUtils.createPanel(new FlowLayout(1), components);
    }

    public static JPanel createPanel(LayoutManager layout, Component ... components) {
        JPanel panel = new JPanel(layout);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            panel.add(comp);
            ++n2;
        }
        return panel;
    }

    public static FileFilter getExtensionFileFilter(String description, String ... extensions) {
        return new ExtensionFileFilter(description, extensions);
    }

    public static JLabel createLabel(String text, int width) {
        return GuiUtils.createLabel(text, width, false);
    }

    public static JLabel createLabel(String text, int width, boolean rightAligned) {
        JLabel label = new JLabel(text);
        Dimension size = label.getPreferredSize();
        if (size.width < width) {
            size.width = width;
        }
        if (rightAligned) {
            label.setHorizontalAlignment(4);
        }
        if (width > 0) {
            label.setPreferredSize(size);
        }
        return label;
    }

    public static Icon extractOptionPaneIcon(String text) {
        JOptionPane opt = new JOptionPane("message", 1);
        return GuiUtils.extractHelper(opt, text);
    }

    public static void forgetWindowLocation(Frame window) {
        ComponentListener[] componentListenerArray = window.getComponentListeners();
        int n = componentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener listener = componentListenerArray[n2];
            if (listener instanceof WindowSettingsComponentAdapter) {
                window.removeComponentListener(listener);
                String title = window.getTitle();
                props.remove(String.valueOf(title) + "-x");
                props.remove(String.valueOf(title) + "-y");
                props.remove(String.valueOf(title) + "-w");
                props.remove(String.valueOf(title) + "-h");
            }
            ++n2;
        }
    }

    public static void growFont(JComponent button) {
        GuiUtils.growFont(button, 1);
    }

    public static void growFont(JComponent button, int amount) {
        Font font = button.getFont();
        font = font.deriveFont((float)(font.getSize() + amount));
        button.setFont(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWindowLocation(Frame window) {
        Properties properties = props;
        synchronized (properties) {
            try {
                String settingsFile = String.valueOf(tempDir) + "/" + SETTINGS_FILENAME;
                if (new File(settingsFile).exists()) {
                    FileInputStream input = new FileInputStream(settingsFile);
                    props.load(input);
                }
            }
            catch (IOException ioe) {
                System.err.println("I/O error trying to load window settings: " + ioe);
            }
            catch (Exception e) {
                System.err.println("Error trying to save window settings: " + e);
            }
        }
        String title = window.getTitle();
        if (props.containsKey(String.valueOf(title) + "-x") && props.containsKey(String.valueOf(title) + "-y")) {
            int x = Integer.parseInt(props.getProperty(String.valueOf(title) + "-x"));
            int y = Integer.parseInt(props.getProperty(String.valueOf(title) + "-y"));
            window.setLocation(x, y);
        }
        if (props.containsKey(String.valueOf(title) + "-w") && props.containsKey(String.valueOf(title) + "-h")) {
            int w = Integer.parseInt(props.getProperty(String.valueOf(title) + "-w"));
            int h = Integer.parseInt(props.getProperty(String.valueOf(title) + "-h"));
            window.setSize(w, h);
        }
    }

    public static void pad(JComponent component, int w, int h) {
        Dimension size = component.getPreferredSize();
        size.width += w;
        size.height += h;
        component.setPreferredSize(size);
    }

    public static void rememberWindowLocation(Frame window) {
        window.addComponentListener(new WindowSettingsComponentAdapter());
        GuiUtils.loadWindowLocation(window);
    }

    public static void shrinkFont(JComponent button) {
        GuiUtils.shrinkFont(button, 1);
    }

    public static void shrinkFont(JComponent button, int amount) {
        Font font = button.getFont();
        font = font.deriveFont((float)(font.getSize() - amount));
        button.setFont(font);
    }

    public static void heighten(JComponent component, int px) {
        GuiUtils.pad(component, 0, px);
    }

    public static void widen(JComponent component, int px) {
        GuiUtils.pad(component, px, 0);
    }

    private GuiUtils() {
    }

    private static Icon extractHelper(Component comp, String text) {
        if (comp instanceof JButton) {
            JButton button = (JButton)comp;
            String buttonText = String.valueOf(button.getText());
            if (buttonText.toUpperCase().contains(text.toUpperCase())) {
                return button.getIcon();
            }
        } else if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            String labelText = String.valueOf(label.getText());
            if (labelText.toUpperCase().contains(text.toUpperCase())) {
                return label.getIcon();
            }
        } else if (comp instanceof Container) {
            Component[] componentArray = ((Container)comp).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component subcomp = componentArray[n2];
                Icon icon = GuiUtils.extractHelper(subcomp, text);
                if (icon != null) {
                    return icon;
                }
                ++n2;
            }
        }
        return null;
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description;
        private String[] extensions;

        public ExtensionFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = extensions;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName().toLowerCase();
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (filename.endsWith(extension = "." + extension.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class WindowSettingsComponentAdapter
    extends ComponentAdapter {
        private WindowSettingsComponentAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent event) {
            Component component = event.getComponent();
            if (!(component instanceof Frame)) {
                return;
            }
            Frame window = (Frame)component;
            int x = window.getX();
            int y = window.getY();
            int w = window.getWidth();
            int h = window.getHeight();
            Properties properties = props;
            synchronized (properties) {
                props.setProperty(String.valueOf(window.getTitle()) + "-x", String.valueOf(x));
                props.setProperty(String.valueOf(window.getTitle()) + "-y", String.valueOf(y));
                props.setProperty(String.valueOf(window.getTitle()) + "-w", String.valueOf(w));
                props.setProperty(String.valueOf(window.getTitle()) + "-h", String.valueOf(h));
                try {
                    String settingsFile = String.valueOf(tempDir) + "/" + GuiUtils.SETTINGS_FILENAME;
                    FileOutputStream out = new FileOutputStream(settingsFile);
                    props.store(out, "Stanford Autograder window location settings");
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {
                    System.err.println("I/O error trying to save window settings: " + ioe);
                }
                catch (Exception e) {
                    System.err.println("Error trying to save window settings: " + e);
                }
            }
        }
    }
}

