/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.SoundClip;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

class SoundPlayer
implements Runnable {
    private static final int PADDING = 400;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int MAX_BUFFER_SIZE = 4096;
    private static final double EPSILON = 1.0E-6;
    private SoundClip soundClip;
    private Thread thread;
    private boolean looping;
    private double oldVolume;

    public SoundPlayer(SoundClip soundClip) {
        this.soundClip = soundClip;
        this.oldVolume = 1.0;
    }

    public void play() {
        if (this.thread != null) {
            return;
        }
        this.looping = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void loop() {
        if (this.thread != null) {
            return;
        }
        this.looping = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.looping = false;
        this.thread = null;
    }

    public void run() {
        byte[] byArray = this.soundClip.getData();
        int n = this.soundClip.getChannelCount();
        int n2 = this.soundClip.getFrameIndex() * n * 2;
        int n3 = this.soundClip.getFrameCount() * n * 2;
        SourceDataLine sourceDataLine = this.openSourceDataLine(Math.min(4096, n3));
        sourceDataLine.start();
        while (this.thread != null) {
            int n4;
            for (int i = n3 - n2; this.thread != null && i > 0; i -= n4) {
                this.setLineVolume(sourceDataLine, this.soundClip.getVolume());
                int n5 = Math.min(4096, i);
                n4 = sourceDataLine.write(byArray, n2, n5);
                n2 += n4;
            }
            if (!this.looping) break;
            n2 = 0;
        }
        if (this.thread == null) {
            this.soundClip.setFrameIndex(n2 / n / 2);
        }
        byArray = new byte[400];
        sourceDataLine.write(byArray, 0, byArray.length);
        sourceDataLine.drain();
        sourceDataLine.stop();
        sourceDataLine.close();
        this.thread = null;
    }

    private SourceDataLine openSourceDataLine(int n) {
        try {
            AudioFormat audioFormat = this.soundClip.getFormat();
            Class<?> clazz = Class.forName("javax.sound.sampled.SourceDataLine");
            DataLine.Info info = new DataLine.Info(clazz, audioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                throw new ErrorException("SoundClip: Unsupported data line format");
            }
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat, n);
            return sourceDataLine;
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setLineVolume(SourceDataLine sourceDataLine, double d) {
        if (this.oldVolume == d) {
            return;
        }
        this.oldVolume = d;
        if (sourceDataLine.isControlSupported(FloatControl.Type.VOLUME)) {
            FloatControl floatControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.VOLUME);
            floatControl.setValue((float)d);
        } else if (sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl floatControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
            double d2 = 20.0 * Math.log(Math.max(d, 1.0E-6)) / Math.log(10.0);
            floatControl.setValue((float)d2);
        }
    }
}

