/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.io.IOConsole;
import acm.io.IOModel;
import acm.program.Program;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.ProgressBarDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

class ThreadedMenuAction
implements Runnable {
    private Program targetProgram;
    private String actionCommand;

    public ThreadedMenuAction(Program program, String string) {
        this.targetProgram = program;
        this.actionCommand = string;
    }

    public void run() {
        ProgressBarDialog progressBarDialog = new ProgressBarDialog(this.targetProgram);
        try {
            if (this.actionCommand.equals("Export Applet")) {
                JTFTools.exportApplet(this.targetProgram, progressBarDialog.getProgressBar());
            } else if (this.actionCommand.equals("Submit Project")) {
                JTFTools.submitProject(this.targetProgram, progressBarDialog.getProgressBar());
            }
        }
        catch (Exception exception) {
            progressBarDialog.setVisible(false);
            IOModel iOModel = this.targetProgram.getDialog();
            if (iOModel == null) {
                iOModel = this.targetProgram.getConsole();
            }
            if (iOModel == null) {
                iOModel = IOConsole.SYSTEM_CONSOLE;
            }
            String string = exception.getMessage();
            if (!(exception instanceof ErrorException)) {
                string = "" + exception;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                printWriter.close();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
                    bufferedReader.readLine();
                    string = string + bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            iOModel.showErrorMessage(string);
        }
    }
}

