/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import stanford.cs106.util.StringUtils;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String stackTraceToString() {
        return ExceptionUtils.stackTraceToString(new RuntimeException());
    }

    public static String stackTraceToString(int lines) {
        return ExceptionUtils.stackTraceToString(new RuntimeException(), lines);
    }

    public static String stackTraceToString(Throwable throwable) {
        return ExceptionUtils.stackTraceToString(throwable, -1);
    }

    public static String stackTraceToString(Throwable throwable, int lines) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(bytes));
        String result = bytes.toString();
        Throwable cause = throwable.getCause();
        if (cause != null) {
            result = String.valueOf(result) + "\n\ncaused by: " + ExceptionUtils.stackTraceToString(cause);
        }
        if (lines >= 0) {
            result = StringUtils.fitToHeight(result, lines);
        }
        return result;
    }

    public static int getLineNumber(Throwable throwable, String className) {
        return ExceptionUtils.getLineNumber(throwable, className, null);
    }

    public static int getLineNumber(Throwable throwable, String className, String methodName) {
        if (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                if ((className == null || ste.getClassName().contains(className)) && (methodName == null || ste.getMethodName().equals(methodName))) {
                    return ste.getLineNumber() + 1;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static String getCallingClassName(String ... classNamesToSkip) {
        RuntimeException re = new RuntimeException();
        StackTraceElement[] stackTraceElementArray = re.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            String[] stringArray = classNamesToSkip;
            int n3 = classNamesToSkip.length;
            int n4 = 0;
            while (n4 < n3) {
                String classNameToSkip = stringArray[n4];
                String className = ste.getClassName();
                if (!className.contains("ExceptionUtils") && className.contains(classNameToSkip)) {
                    return className;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static String getMethodName(Throwable throwable, String className) {
        if (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                if (className == null || ste.getClassName().contains(className)) {
                    return ste.getMethodName();
                }
                ++n2;
            }
        }
        return "";
    }

    public static Throwable getUnderlyingCause(Throwable t) {
        while (t != null && t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

