/* *********************************************************
 * Write a program to count the number of occurrences of
 * each unique word in a text file and make certain reports.
 *
 * (1) TOP WORDS REPORT: Report all words that appeared in
 * the book at least 10 times, in alphabetical order.
 *
 * (2) QUERY MODE: Allow the user to type a word and report
 * how many times that word appeared in the book. Repeat.
 *
 * Cynthia Lee 2014
 * CS106B
 ***********************************************************/

#include "console.h"
#include "map.h"
#include "simpio.h"
#include "filelib.h"
using namespace std;
#include <iostream>
#include <fstream>

static void countWords(ifstream& infile, Map<string, int>& wordCounts);
static void topWordsReport(Map<string, int>& wordCounts);
static void wordQueryMode(Map<string, int>& wordCounts);

static const int TOP_WORDS_CUTOFF = 10;

int main() {
    ifstream infile;
    Map<string,int> wordCounts;
    promptUserForFile(infile, "Enter filename (e.g. Hurston_Poker.txt): ");
    countWords(infile, wordCounts);
    topWordsReport(wordCounts);
    wordQueryMode(wordCounts);
    return 0;
}


// Write a program to count the number of occurrences of
// each unique word in a text file
static void countWords(ifstream& infile, Map<string, int>& wordCounts) {
    string word;
    infile >> word;
    while (!infile.fail()){
        wordCounts[word]++; // Note that this works even if 'word' is a new word
        infile >> word;
    }
}

// Report all words that appeared in the book at least TOP_WORDS_CUTOFF
// times, in alphabetical order
static void topWordsReport(Map<string, int>& wordCounts) {
    cout << "Report of most common words:" << endl;
    for (string word : wordCounts) {
        if (wordCounts[word] >= TOP_WORDS_CUTOFF) {
            cout << word << ": " << wordCounts[word] << endl;
        }
    }
}


// Allow the user to type a word and report how many
// times that word appeared in the book
static void wordQueryMode(Map<string, int>& wordCounts) {
    while (true) {
        string word = getLine("Enter a word: ");
        if (word == "") break;
        int count = 0;
        //Note that we guard the access to wordCounts with a containsKey() so
        // that we don't insert (with zero count) words not already in the map
        if (wordCounts.containsKey(word)) {
            count = wordCounts[word];
        }
        cout << "That word occurs " << count << " times." << endl;
    }
}

