/**
 * json-lite-inheritance.cpp
 * -------------------------
 * Provides the test framework to illustrate how inheritance works.
 *
 * Original code by Jerry Cain and Aubrey Gress
 * Updated for CS106X AUT1516 by Cynthia Lee
 * 2015-11-16
 */

#include "console.h"
#include "vector.h"
#include "map.h"
#include "strlib.h"
#include "tokenscanner.h"
#include "error.h"
#include "simpio.h"
#include <fstream>
using namespace std;

class JSONElement {
public:
	virtual ~JSONElement() {};
	virtual string toString() = 0;
private:
};

class JSONInt : public JSONElement {
public:
	JSONInt(int i) { value = i; }
	~JSONInt () {}
	string toString() { return integerToString(value); };
private:
	int value;
};

JSONElement *parseJSON(TokenScanner& scanner) {
	string lookahead = scanner.nextToken();
	if (lookahead.empty()) return NULL;
	
	if (isdigit(lookahead[0])) {
		return new JSONInt(stringToInteger(lookahead));
	} else {
		error("JSON element type passed to parseJSON not yet supported.");
	}

	// should never get to the bottom here, but compiler can't figure that out
	return NULL;
}

int main() {
    setConsoleSize(1000, 700);
    setConsoleFont("Courier-BOLD-18");
	TokenScanner scanner;
	scanner.ignoreWhitespace();
    scanner.scanStrings();
	
    ifstream infile("json-lite-data.txt");
	scanner.setInput(infile);

	while (true) {
		try {			
			JSONElement *jsonRoot = parseJSON(scanner);
			if (jsonRoot == NULL) break;
			cout << jsonRoot->toString() << endl;
			delete jsonRoot;
		} catch (ErrorException& ex) {
			cout << ex.getMessage() << endl;
		}
	}
	
	cout << endl;
    getLine("Everything's been read in and printed out. Press ENTER to quit.");
	return 0;
};

