/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.reflect;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import stanford.cs106.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    public static final String CLASS_EXTENSION = ".class";
    public static final String JAVA_EXTENSION = ".java";
    private static final FileFilter CLASS_FILTER = new ExtensionFilter(".class");
    private static boolean SHOULD_CACHE = false;

    public static boolean hasMain(Class<?> clazz) {
        try {
            Method main = clazz.getMethod("main", new String[0].getClass());
            int mod = main.getModifiers();
            return Modifier.isStatic(mod) && Modifier.isPublic(mod) && main.getReturnType() == Void.TYPE;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static void runMain(Class<?> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ClassUtils.runMain(clazz, null);
    }

    public static void runMain(Class<?> clazz, String[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method main = clazz.getMethod("main", new String[0].getClass());
        int mod = main.getModifiers();
        if (Modifier.isStatic(mod) && Modifier.isPublic(mod) && main.getReturnType() == Void.TYPE) {
            main.invoke(null, new Object[]{args});
        }
    }

    public static List<String> getClassPathFolders() {
        try {
            String classPath = System.getProperty("java.class.path").trim();
            if (classPath.length() == 0) {
                classPath = ".";
            }
            String[] tokens = classPath.split(File.pathSeparator);
            HashSet<String> absPaths = new HashSet<String>();
            ArrayList<String> pruned = new ArrayList<String>();
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                File tokenFile = new File(token);
                if (tokenFile.isDirectory() && !absPaths.contains(tokenFile.getAbsolutePath())) {
                    pruned.add(token);
                    absPaths.add(tokenFile.getAbsolutePath());
                }
                ++n2;
            }
            return pruned;
        }
        catch (AccessControlException e) {
            return Arrays.asList(".");
        }
    }

    public static Set<Field> getFields(Class<?> clazz, Class<?> type) {
        return ClassUtils.getFields(clazz, type, null);
    }

    public static Set<Field> getFields(Class<?> clazz, Class<?> type, Class<?> parameterizedType) {
        return ClassUtils.getFields(clazz, type, parameterizedType, false);
    }

    public static Set<Field> getFields(Class<?> clazz, Class<?> type, Class<?> parameterizedType, boolean allowSubtype) {
        return ClassUtils.getFields(clazz, new LinkedHashSet(CollectionUtils.asSet(type)), parameterizedType, allowSubtype);
    }

    public static Set<Field> getFields(Class<?> clazz, Set<Class<?>> types, Class<?> parameterizedType, boolean allowSubtype) {
        LinkedHashSet<Field> resultFields = new LinkedHashSet<Field>();
        ArrayList<String> fieldNames = new ArrayList<String>(ClassUtils.getFieldNames(clazz));
        ArrayList fieldTypes = new ArrayList(ClassUtils.getFieldTypes(clazz));
        int i = 0;
        while (i < fieldNames.size()) {
            String fieldName = (String)fieldNames.get(i);
            Class fieldType = (Class)fieldTypes.get(i);
            for (Class<?> type : types) {
                if (fieldType != type && (!allowSubtype || !type.isAssignableFrom(fieldType))) continue;
                if (parameterizedType == null) {
                    try {
                        resultFields.add(clazz.getDeclaredField(fieldName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    ParameterizedType paramType;
                    Type paramRealType;
                    Field field = clazz.getDeclaredField(fieldName);
                    Type genericType = field.getGenericType();
                    if (genericType == null || !(genericType instanceof ParameterizedType) || (paramRealType = (paramType = (ParameterizedType)genericType).getActualTypeArguments()[0]) != parameterizedType) continue;
                    resultFields.add(field);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return resultFields;
    }

    public static Set<String> getFieldNames(Class<?> clazz) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) {
                fields.add(field.getName());
            }
            ++n2;
        }
        return fields;
    }

    public static List<Class<?>> getFieldTypes(Class<?> clazz) {
        ArrayList fields = new ArrayList();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) {
                fields.add(field.getType());
            }
            ++n2;
        }
        return fields;
    }

    public static String getFirstClassPathFolder() {
        List<String> folders = ClassUtils.getClassPathFolders();
        if (folders.size() == 0) {
            return ".";
        }
        String folder = folders.get(0).trim();
        if (folder.length() == 0) {
            return ".";
        }
        return folder;
    }

    public static Set<String> getNonPrivateFieldNames(String className) {
        return ClassUtils.getNonPrivateFieldNames(className, false);
    }

    public static Set<String> getNonPrivateFieldNames(String className, boolean allowProtected) {
        try {
            return ClassUtils.getNonPrivateFieldNames(Class.forName(className), allowProtected);
        }
        catch (ClassNotFoundException e) {
            return Collections.emptySet();
        }
    }

    public static Set<String> getNonPrivateFieldNames(Class<?> clazz) {
        return ClassUtils.getNonPrivateFieldNames(clazz, false);
    }

    public static Set<String> getNonPrivateFieldNames(Class<?> clazz, boolean allowProtected) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mod = field.getModifiers();
            if (!(Modifier.isPrivate(mod) || allowProtected && Modifier.isProtected(mod) || Modifier.isStatic(mod) && Modifier.isFinal(mod))) {
                fields.add(field.getName());
            }
            ++n2;
        }
        return fields;
    }

    public static Set<String> getNonPrivateMethodNames(Class<?> clazz) {
        return ClassUtils.getNonPrivateMethodNames(clazz, false);
    }

    public static Set<String> getNonPrivateMethodNames(Class<?> clazz, boolean allowProtected) {
        LinkedHashSet<String> methods = new LinkedHashSet<String>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (!(Modifier.isPrivate(mod) || allowProtected && Modifier.isProtected(mod))) {
                methods.add(method.getName());
            }
            ++n2;
        }
        return methods;
    }

    public static Set<Method> getNonPrivateMethods(Class<?> clazz) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (!Modifier.isPrivate(mod)) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public static Set<Constructor<?>> getNonPrivateConstructors(Class<?> clazz) {
        LinkedHashSet constructors = new LinkedHashSet();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            int mod = ctor.getModifiers();
            if (!Modifier.isPrivate(mod)) {
                constructors.add(ctor);
            }
            ++n2;
        }
        return constructors;
    }

    public static Set<String> getMethodNames(Class<?> clazz) {
        LinkedHashSet<String> methods = new LinkedHashSet<String>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            methods.add(method.getName());
            ++n2;
        }
        return methods;
    }

    public static boolean isInnerClass(String className) {
        return className.indexOf(36) >= 0;
    }

    public static boolean isNetworkClass(String className) {
        return className.indexOf(95) >= 0 && !ClassUtils.isInnerClass(className);
    }

    public static boolean isDrJavasFault(String className) {
        return new File(String.valueOf(className) + CLASS_EXTENSION).exists() && System.getProperties().toString().toLowerCase().indexOf("drjava") >= 0;
    }

    public static Class<?> writeAndLoadClass(String fileText, String className, boolean useTempFolder) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String javaFileName = String.valueOf(className) + JAVA_EXTENSION;
        if (useTempFolder) {
            javaFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + javaFileName;
        }
        ClassUtils.writeEntireFile(fileText, javaFileName);
        String classFileName = ClassUtils.compile(javaFileName);
        new File(javaFileName).delete();
        new File(classFileName).renameTo(new File("." + File.separatorChar + className + CLASS_EXTENSION));
        return ClassUtils.loadClass(classFileName);
    }

    public static String compile(String fileName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String folderName = ClassUtils.getFolder(fileName);
        String sep = System.getProperty("path.separator");
        String[] args = new String[]{"-classpath", "." + sep + folderName, fileName};
        Class<?> compilerClass = Class.forName("com.sun.tools.javac.Main");
        Method compileMethod = compilerClass.getMethod("compile", new String[0].getClass());
        compileMethod.invoke(null, new Object[]{args});
        int result = 0;
        if (result != 0) {
            throw new RuntimeException("Compilation failed: error code " + result);
        }
        return String.valueOf(ClassUtils.removeExtension(fileName)) + CLASS_EXTENSION;
    }

    public static String downloadFile(URL url) throws IOException {
        String fileName = ClassUtils.removeFolder(url.getFile());
        if (!SHOULD_CACHE || !new File(fileName).exists()) {
            int numRead;
            PrintStream output = new PrintStream(fileName);
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            byte[] buffer = new byte[512000];
            while ((numRead = ((InputStream)input).read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, numRead);
            }
            ((OutputStream)output).close();
        }
        return fileName;
    }

    public static <T> List<Class<? extends T>> getClasses(Class<T> superClass, String folderName) {
        try {
            ArrayList<Class<T>> list = new ArrayList<Class<T>>();
            File folder = new File(folderName);
            if (!folder.exists() || !folder.canRead()) {
                return list;
            }
            File[] fileArray = folder.listFiles(CLASS_FILTER);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (file.canRead() && !file.isDirectory() && fileName.endsWith(CLASS_EXTENSION)) {
                    try {
                        Class<?> existingClass = Class.forName(ClassUtils.removeExtension(fileName));
                        if (existingClass != null && !existingClass.isInterface() && !Modifier.isAbstract(existingClass.getModifiers()) && superClass.isAssignableFrom(existingClass)) {
                            list.add(existingClass);
                        }
                    }
                    catch (IncompatibleClassChangeError icce) {
                        icce.printStackTrace();
                    }
                    catch (Throwable t) {
                        System.out.println("error reading " + fileName + ":");
                        t.printStackTrace();
                    }
                }
                ++n2;
            }
            Collections.sort(list, new ClassComparator());
            return list;
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static Map<String, byte[]> getZipFileContents(URL url) throws IOException {
        String fileName = ClassUtils.downloadFile(url);
        ZipFile zip = new ZipFile(fileName);
        TreeMap<String, byte[]> zipFilesMap = new TreeMap<String, byte[]>();
        Enumeration<? extends ZipEntry> enu = zip.entries();
        while (enu.hasMoreElements()) {
            int size;
            ZipEntry ze = enu.nextElement();
            if (ze.isDirectory() || (size = (int)ze.getSize()) < 0) continue;
            InputStream input = zip.getInputStream(ze);
            byte[] b = new byte[size];
            int offset = 0;
            while (size - offset > 0) {
                int bytesRead = input.read(b, offset, size - offset);
                if (bytesRead < 0) break;
                offset += bytesRead;
            }
            zipFilesMap.put(ze.getName(), b);
        }
        zip.close();
        return zipFilesMap;
    }

    public static boolean classImplements(Class<?> clazz, Class<?> interfaceType) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c == interfaceType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class<?> loadClass(String fileName) throws ClassNotFoundException {
        ClassLoader loader;
        String folderName = ClassUtils.getFolder(fileName);
        File folder = new File(folderName);
        ClassLoader urlLoader = loader = ClassLoader.getSystemClassLoader();
        try {
            URL fileUrl = new URL("file:" + System.getProperty("user.dir") + File.separator + fileName);
            File currentDir = new File(System.getProperty("user.dir"));
            urlLoader = URLClassLoader.newInstance(new URL[]{folder.toURI().toURL(), currentDir.toURI().toURL(), fileUrl}, loader);
        }
        catch (MalformedURLException mfurle) {
            mfurle.printStackTrace();
        }
        String className = ClassUtils.removeExtension(ClassUtils.removeFolder(fileName));
        try {
            Class<?> clazz = urlLoader.loadClass(className);
            return clazz;
        }
        catch (IncompatibleClassChangeError icce) {
            throw new RuntimeException("Unable to load the class: " + icce);
        }
    }

    public static String readEntireFile(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        StringBuilder text = new StringBuilder();
        while (reader.ready()) {
            text.append((char)reader.read());
        }
        reader.close();
        return text.toString();
    }

    public static byte[] readEntireFileBytes(String fileName) throws IOException {
        File file = new File(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        FileInputStream stream = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while (reader.ready()) {
            out.write(reader.read());
        }
        reader.close();
        return out.toByteArray();
    }

    public static String readAndRename(String oldClassName, String newClassName) throws IOException {
        String fileName = String.valueOf(oldClassName) + JAVA_EXTENSION;
        String fileText = ClassUtils.readEntireFile(fileName);
        fileText = fileText.replaceAll(oldClassName, newClassName);
        return fileText;
    }

    public static String renameAndWriteJavaFile(String fileText, String oldClassName, String newClassName, boolean useTempFolder) {
        fileText = fileText.replaceAll(oldClassName, newClassName);
        String newFileName = String.valueOf(newClassName) + JAVA_EXTENSION;
        if (useTempFolder) {
            newFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + newFileName;
        }
        ClassUtils.writeEntireFile(fileText, newFileName);
        return newFileName;
    }

    public static void writeEntireFile(String text, String fileName) {
        try {
            PrintStream output = new PrintStream(fileName);
            output.print(text);
            output.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public static String stripPackages(Class<?> clazz) {
        return ClassUtils.stripPackages(clazz.getName());
    }

    public static String stripPackages(String className) {
        return className.replaceAll(".*\\.", "");
    }

    public static String sanitizeClassName(String text) {
        text = text.replaceAll("[^A-Za-z0-9_$]+", "_");
        return text;
    }

    public static void writeBytes(byte[] bytes, String fileName) throws IOException {
        FileOutputStream output = new FileOutputStream(fileName);
        output.write(bytes);
        output.close();
    }

    private static String getFolder(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            slash = fileName.lastIndexOf("/");
        }
        if (slash >= 0) {
            return fileName.substring(0, slash + 1);
        }
        return "./";
    }

    public static boolean reflectionEquals(Object o1, Object o2) {
        Class<?> clazz2;
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return o1 == null;
        }
        if (o1 == o2) {
            return true;
        }
        Class<?> clazz1 = o1.getClass();
        if (clazz1 != (clazz2 = o2.getClass())) {
            return false;
        }
        Field[] fieldArray = clazz1.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object f2;
            Object f1;
            Field field;
            block11: {
                field = fieldArray[n2];
                try {
                    field.setAccessible(true);
                    f1 = field.get(o1);
                    f2 = field.get(o2);
                    if ((f1 != null || f2 == null) && (f2 != null || f1 == null)) break block11;
                    return false;
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
            }
            if (f1 != null && f2 != null) {
                Class<?> fieldType = field.getType();
                if (fieldType.isArray()) {
                    throw new UnsupportedOperationException("array fields not supported right now");
                }
                if (!f1.equals(f2)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static String removeExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot >= 0) {
            fileName = fileName.substring(0, dot);
        }
        return fileName;
    }

    private static String removeFolder(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            slash = fileName.lastIndexOf("/");
        }
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        return fileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassComparator
    implements Comparator<Class<?>> {
        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }

    public static class ExtensionFilter
    implements FileFilter {
        private String extension;

        public ExtensionFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File f) {
            return f != null && f.exists() && f.canRead() && f.getName().endsWith(this.extension);
        }
    }
}

