/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanford.cs106.reflect.ReflectionRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static String getClassNameWithoutPackage(String className) {
        int space = className.lastIndexOf(46);
        if (space >= 0) {
            className = className.substring(space + 1);
        }
        return className;
    }

    public static String getClassNameWithoutPackage(Class<?> clazz) {
        return ReflectionUtils.getClassNameWithoutPackage(clazz, null);
    }

    public static String getClassNameWithoutPackage(Class<?> clazz, Type genericType) {
        ParameterizedType paramGenericType;
        Type[] paramArgs;
        String className = clazz.getName();
        if (clazz.isArray()) {
            className = String.valueOf(clazz.getComponentType().getName()) + "[]";
        } else if (genericType instanceof ParameterizedType && (paramArgs = (paramGenericType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            className = String.valueOf(className) + "<";
            int i = 0;
            while (i < paramArgs.length) {
                Class paramType = (Class)paramArgs[i];
                if (i > 0) {
                    className = String.valueOf(className) + ", ";
                }
                className = String.valueOf(className) + ReflectionUtils.getClassNameWithoutPackage(paramType);
                ++i;
            }
            className = String.valueOf(className) + ">";
        }
        int space = className.lastIndexOf(46);
        if (space >= 0) {
            className = className.substring(space + 1);
        }
        return className;
    }

    public static boolean constantExists(Class<?> clazz, String constantNameRegex) {
        Field constantField = ReflectionUtils.getFieldToMatchRegex(clazz, constantNameRegex);
        return constantField != null;
    }

    public static boolean constantExists(String className, String constantNameRegex) {
        Class<?> clazz = ReflectionUtils.classForName(className);
        return ReflectionUtils.constantExists(clazz, constantNameRegex);
    }

    public static Object getConstantValue(Class<?> clazz, String constantNameRegex) {
        return ReflectionUtils.getConstantValue(clazz, null, constantNameRegex);
    }

    public static Object getConstantValue(Class<?> clazz, Object obj, String constantNameRegex) {
        try {
            Field constantField = ReflectionUtils.getFieldToMatchRegex(clazz, constantNameRegex);
            if (constantField != null) {
                if (Modifier.isStatic(constantField.getModifiers())) {
                    return constantField.get(null);
                }
                return constantField.get(obj);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
        throw new ReflectionRuntimeException("Unable to get constant in class " + clazz.getName() + " with approximate name \"" + constantNameRegex + "\"; no matching constant field found");
    }

    public static Object getConstantValue(String className, String constantNameRegex) {
        Class<?> clazz = ReflectionUtils.classForName(className);
        return ReflectionUtils.getConstantValue(clazz, constantNameRegex);
    }

    public static double getConstantValueDouble(Class<?> clazz, Object obj, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(clazz, obj, constantNameRegex);
        return Double.parseDouble(String.valueOf(value));
    }

    public static double getConstantValueDouble(Class<?> clazz, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(clazz, constantNameRegex);
        return Double.parseDouble(String.valueOf(value));
    }

    public static double getConstantValueDouble(String className, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(className, constantNameRegex);
        return Double.parseDouble(String.valueOf(value));
    }

    public static int getConstantValueInt(Class<?> clazz, Object obj, String constantNameRegex) {
        return (int)ReflectionUtils.getConstantValueDouble(clazz, obj, constantNameRegex);
    }

    public static int getConstantValueInt(Class<?> clazz, String constantNameRegex) {
        return (int)ReflectionUtils.getConstantValueDouble(clazz, constantNameRegex);
    }

    public static int getConstantValueInt(String className, String constantNameRegex) {
        return (int)ReflectionUtils.getConstantValueDouble(className, constantNameRegex);
    }

    public static boolean getConstantValueBoolean(Class<?> clazz, Object obj, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(clazz, obj, constantNameRegex);
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public static boolean getConstantValueBoolean(Class<?> clazz, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(clazz, constantNameRegex);
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public static boolean getConstantValueBoolean(String className, String constantNameRegex) {
        Object value = ReflectionUtils.getConstantValue(className, constantNameRegex);
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public static Field getFieldToMatchRegex(Class<?> clazz, String constantNameRegex) {
        return ReflectionUtils.getFieldToMatchRegex(clazz, constantNameRegex, true);
    }

    public static Field getFieldToMatchRegex(Class<?> clazz, String constantNameRegex, boolean includeSuperclasses) {
        try {
            while (clazz != null) {
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    String constantName = field.getName();
                    if (constantNameRegex.isEmpty() || constantName.equalsIgnoreCase(constantNameRegex) || constantName.toUpperCase().matches(".*" + constantNameRegex.toUpperCase() + ".*")) {
                        field.setAccessible(true);
                        Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers");
                        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                        return field;
                    }
                    ++n2;
                }
                clazz = includeSuperclasses ? clazz.getSuperclass() : null;
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
        throw new IllegalArgumentException("No field with approximate name \"" + constantNameRegex + "\"");
    }

    public static void setConstantValue(Class<?> clazz, String constantNameRegex, Object value) {
        ReflectionUtils.setConstantValue(clazz, null, constantNameRegex, value);
    }

    public static void setConstantValue(Class<?> clazz, Object obj, String constantNameRegex, Object value) {
        boolean set = false;
        try {
            Field constantField = ReflectionUtils.getFieldToMatchRegex(clazz, constantNameRegex);
            if (Modifier.isStatic(constantField.getModifiers())) {
                constantField.set(null, value);
            } else {
                constantField.set(obj, value);
            }
            Object newValue = ReflectionUtils.getConstantValue(clazz, obj, constantField.getName());
            if (!newValue.equals(value)) {
                throw new ReflectionRuntimeException("constant \"" + constantField.getName() + "\" is " + newValue + ", not properly set to " + value);
            }
            set = true;
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
        if (!set) {
            throw new ReflectionRuntimeException("Unable to set constant in class " + clazz.getName() + " with approximate name \"" + constantNameRegex + "\"; no matching constant field found");
        }
    }

    public static void setConstantValue(String className, String constantNameRegex, Object value) {
        Class<?> clazz = ReflectionUtils.classForName(className);
        ReflectionUtils.setConstantValue(clazz, null, constantNameRegex, value);
    }

    public static Object[] getDefaultArgs(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramValues[i] = ReflectionUtils.getDefaultValue(paramTypes[i]);
            ++i;
        }
        return paramValues;
    }

    public static Object getDefaultValue(Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Short.TYPE || type == Short.class) {
            return 0L;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return false;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == String.class) {
            return "";
        }
        return null;
    }

    public static Object getFirstFieldValueOfType(Class<?> clazz, Object obj, Class<?> fieldType) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (fieldType.isAssignableFrom(field.getType())) {
                return ReflectionUtils.getFieldValue(obj, field);
            }
            ++n2;
        }
        return null;
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers");
            field.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return field.get(obj);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
    }

    public static Object getFieldValue(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        try {
            Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers");
            modifiersField.setAccessible(true);
            Field field = ReflectionUtils.getField(clazz, name);
            String fieldName = field.getName();
            if (fieldName.equals(name)) {
                field.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                return field.get(obj);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
        throw new IllegalArgumentException("Fields.get: unable to read field \"" + name + "\" from class " + clazz.getName());
    }

    public static Object parseValue(Class<?> type, String value) {
        return ReflectionUtils.parseValue(type, null, value);
    }

    public static Object parseValue(Class<?> type, Type genericType, String value) {
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            if (value.length() > 2 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                value = value.substring(1, value.length() - 1);
            }
            return Character.valueOf(value.charAt(0));
        }
        if (type == String.class) {
            if (value.length() > 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        if (type == List.class || type == ArrayList.class || type.isArray()) {
            if ((value = value.trim()).startsWith("[") || value.startsWith("{") || value.startsWith("(")) {
                value = value.substring(1);
            }
            if (value.endsWith("]") || value.endsWith("}") || value.endsWith(")")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] elements = value.split("[ \t]*,[ \t]*");
            ArrayList<Object> list = new ArrayList<Object>();
            Class paramType = Object.class;
            ParameterizedType paramGenericType = (ParameterizedType)genericType;
            if (paramGenericType.getActualTypeArguments().length > 0) {
                paramType = (Class)paramGenericType.getActualTypeArguments()[0];
            }
            int i = 0;
            while (i < elements.length) {
                if (paramType == null || paramType == Object.class || paramType == String.class) {
                    list.add(elements[i]);
                } else {
                    list.add(ReflectionUtils.parseValue(paramType, elements[i]));
                }
                ++i;
            }
            if (type.isArray()) {
                Object[] array = (Object[])Array.newInstance(type.getComponentType(), 0);
                return list.toArray(array);
            }
            return list;
        }
        if (type == Map.class || type == HashMap.class) {
            if ((value = value.trim()).startsWith("[") || value.startsWith("{") || value.startsWith("(")) {
                value = value.substring(1);
            }
            if (value.endsWith("]") || value.endsWith("}") || value.endsWith(")")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] elements = value.split("[ \t]*,[ \t]*");
            HashMap<String, String> map = new HashMap<String, String>();
            Class keyType = Object.class;
            Class valueType = Object.class;
            ParameterizedType paramGenericType = (ParameterizedType)genericType;
            if (paramGenericType.getActualTypeArguments().length >= 2) {
                keyType = (Class)paramGenericType.getActualTypeArguments()[0];
                valueType = (Class)paramGenericType.getActualTypeArguments()[1];
            }
            int i = 0;
            while (i < elements.length) {
                String[] keyValue = elements[i].split("[ \t]*=[ \t]*");
                if (keyValue.length >= 2) {
                    Object kv_key = keyValue[0];
                    Object kv_value = keyValue[1];
                    if (keyType != null && keyType != Object.class && keyType != String.class) {
                        kv_key = ReflectionUtils.parseValue(keyType, keyValue[0]);
                    }
                    if (valueType != null && valueType != Object.class && valueType != String.class) {
                        kv_value = ReflectionUtils.parseValue(valueType, keyValue[1]);
                    }
                    map.put((String)kv_key, (String)kv_value);
                }
                ++i;
            }
            return map;
        }
        throw new IllegalArgumentException("Fields.parseValue: unable to parse value \"" + value + "\" of type " + type.getName());
    }

    public static void setFieldValue(Class<?> clazz, String name, Object value) {
        try {
            Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers");
            Field field = ReflectionUtils.getField(clazz, name);
            String fieldName = field.getName();
            if (fieldName.equals(name)) {
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(null, value);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        try {
            Field modifiersField = ReflectionUtils.getField(Field.class, "modifiers");
            field.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(obj, value);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionRuntimeException(iae);
        }
    }

    public static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionRuntimeException(cnfe);
        }
    }

    public static Object staticMethodInvoke(String className, String methodName, Object ... params) {
        return ReflectionUtils.staticMethodInvoke(ReflectionUtils.classForName(className), methodName, params);
    }

    public static Object staticMethodInvoke(Class<?> clazz, String methodName, Object ... params) {
        return ReflectionUtils.methodInvoke(clazz, null, methodName, params);
    }

    public static Object methodInvoke(String className, Object obj, String methodName, Object ... params) {
        return ReflectionUtils.methodInvoke(ReflectionUtils.classForName(className), obj, methodName, params);
    }

    public static Object methodInvoke(Class<?> clazz, Object obj, String methodName, Object ... params) {
        try {
            Method method = ReflectionUtils.getMethod(clazz, methodName);
            if (method != null) {
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                return method.invoke(obj, params);
            }
            return null;
        }
        catch (IllegalAccessException ite) {
            throw new ReflectionRuntimeException(ite);
        }
        catch (InvocationTargetException ite) {
            throw new ReflectionRuntimeException(ite);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method method;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        methodArray = clazz.getMethods();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getField(clazz, fieldName, true);
    }

    public static Field getField(Class<?> clazz, String fieldName, boolean checkSuperclasses) {
        Class<?> currentClazz = clazz;
        while (currentClazz != null) {
            Field[] fieldArray = currentClazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(fieldName)) {
                    field.setAccessible(true);
                    return field;
                }
                ++n2;
            }
            if (!checkSuperclasses) break;
            currentClazz = currentClazz.getSuperclass();
        }
        throw new ReflectionRuntimeException("no field named \"" + fieldName + "\" found in " + clazz);
    }

    public static Class<?> primitiveFor(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldNameComparator
    implements Comparator<Field> {
        @Override
        public int compare(Field arg0, Field arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method arg0, Method arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

