/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import acm.program.Program;
import acm.program.ProgramMenuBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import stanford.karel.Event;
import stanford.karel.Karel;
import stanford.karel.KarelControlPanel;
import stanford.karel.KarelErrorDialog;
import stanford.karel.KarelWorld;

public class KarelProgram
extends Program {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int INFINITE = 99999999;
    public static final int SIMPLE = 0;
    public static final int FANCY = 1;
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    private static final Color DARK_YELLOW = Color.YELLOW.darker().darker().darker();
    private static final Color DARK_GREEN = Color.GREEN.darker().darker();
    private static final Color DARK_RED = Color.RED.darker();
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    private static final String CONFIG_FILE_NAME = "karel-settings.txt";
    private KarelWorld world;
    private KarelControlPanel controlPanel;
    private KarelErrorDialog errorDialog;
    private JLabel statusLabel;
    private JCheckBoxMenuItem msKarelItem;
    private boolean started;
    public Event<State> StateEvent = new Event("StateEvent");

    public KarelProgram() {
        this.world = this.createWorld();
        this.world.setRepaintFlag(false);
        this.world.setDisplayFlag(false);
        this.world.init(10, 10);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.world);
        this.controlPanel = new KarelControlPanel(this);
        this.world.setMonitor(this.controlPanel);
        panel.add("West", this.controlPanel);
        this.add(panel);
        this.statusLabel = new JLabel("Welcome to Karel!");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.add((Component)this.statusLabel, "South");
        this.validate();
    }

    public void main() {
    }

    public void setStatus(String status) {
        if (status.contains("Running")) {
            this.statusLabel.setForeground(DARK_YELLOW);
        } else if (status.contains("due to an error")) {
            this.statusLabel.setForeground(DARK_RED);
        } else if (status.contains("Finished")) {
            this.statusLabel.setForeground(DARK_GREEN);
        } else {
            this.statusLabel.setForeground(new JLabel().getForeground());
        }
        this.statusLabel.setText(status);
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public static String getWorldDirectory() {
        String dir = System.getProperty("user.dir");
        if (new File(dir, "worlds").isDirectory()) {
            dir = String.valueOf(dir) + "/worlds";
        }
        return dir;
    }

    protected KarelWorld createWorld() {
        return new KarelWorld();
    }

    protected boolean isStarted() {
        if (this.world == null || !super.isStarted()) {
            return false;
        }
        Dimension size = this.world.getSize();
        return size != null && size.width != 0 && size.height != 0;
    }

    protected Karel getKarel() {
        return this.world.getKarel();
    }

    public void add(Karel karel) {
        this.add(karel, 1, 1, 1, 99999999);
    }

    public void add(Karel karel, int x, int y, int dir, int nBeepers) {
        karel.setLocation(x, y);
        karel.setDirection(dir);
        karel.setBeepersInBag(nBeepers);
        this.world.add(karel);
    }

    public void start(String[] args) {
        super.start(args);
    }

    protected void setStartupObject(Object obj) {
        super.setStartupObject(obj);
    }

    protected void augmentMenuBar() {
        try {
            ProgramMenuBar bar = this.getConsole().getMenuBar();
            bar.removeAll();
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic('F');
            JMenuItem quitItem = new JMenuItem("Quit");
            quitItem.setMnemonic('Q');
            quitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    KarelProgram.this.stop();
                    KarelProgram.this.destroy();
                    KarelProgram.this.setVisible(false);
                    try {
                        System.exit(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            fileMenu.add(quitItem);
            JMenu optionsMenu = new JMenu("Options");
            optionsMenu.setMnemonic('O');
            this.msKarelItem = new JCheckBoxMenuItem("Ms. Karel");
            this.msKarelItem.setMnemonic('M');
            this.msKarelItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    KarelProgram.this.world.setMsKarel(KarelProgram.this.msKarelItem.isSelected());
                    KarelProgram.this.saveConfiguration();
                }
            });
            optionsMenu.add(this.msKarelItem);
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic('H');
            JMenuItem aboutItem = new JMenuItem("About Karel...");
            aboutItem.setActionCommand("About Karel...");
            aboutItem.setMnemonic('A');
            aboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JOptionPane.showMessageDialog(KarelProgram.this, "Karel the Robot\nversion: 2015/04/05\n\nThe karel.jar library was designed and written by Stanford Prof. Eric Roberts.\nMinor modifications have been made by Stanford Lecturer Marty Stepp.\n\nSee http://cs106a.stanford.edu/ for more information.");
                }
            });
            helpMenu.add(aboutItem);
            bar.add(fileMenu);
            bar.add(optionsMenu);
            bar.add(helpMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadConfiguration() {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                File configFile = new File(tmpDir, CONFIG_FILE_NAME);
                if (!configFile.exists()) {
                    return;
                }
                Properties props = new Properties();
                FileInputStream input = new FileInputStream(configFile);
                props.load(input);
                input.close();
                if (props.containsKey("mskarel")) {
                    boolean msKarel = Boolean.parseBoolean(String.valueOf(props.get("mskarel")));
                    this.msKarelItem.setSelected(msKarel);
                    this.world.setMsKarel(msKarel);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveConfiguration() {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                File configFile = new File(tmpDir, CONFIG_FILE_NAME);
                Properties props = new Properties();
                props.put("mskarel", String.valueOf(this.msKarelItem.isSelected()));
                FileOutputStream out = new FileOutputStream(configFile);
                props.store(out, "Karel configuration file");
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startRun() {
        Object worldName;
        this.augmentMenuBar();
        if (!this.isAppletMode()) {
            this.loadConfiguration();
        }
        Karel karel = null;
        String karelClass = this.getParameter("karel");
        if (karelClass == null) {
            karel = (Karel)this.getStartupObject();
            karelClass = karel.getClass().getName();
            karelClass = karelClass.substring(karelClass.lastIndexOf(".") + 1);
        } else {
            try {
                karel = (Karel)Class.forName(karelClass).newInstance();
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex);
            }
        }
        if (karel != null) {
            this.world.add(karel);
            this.setTitle(karelClass);
            worldName = this.getParameter("world");
            if (worldName == null) {
                worldName = karelClass;
            }
            try {
                URL url = new URL(this.getCodeBase(), "worlds/" + (String)worldName + ".w");
                URLConnection connection = url.openConnection();
                this.world.load(new InputStreamReader(connection.getInputStream()));
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        this.world.setRepaintFlag(true);
        this.world.setDisplayFlag(true);
        this.world.repaint();
        while (true) {
            String errorMessage;
            block28: {
                this.started = false;
                worldName = this;
                synchronized (worldName) {
                    while (true) {
                        while (true) {
                            if (this.started) {
                                break block28;
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException url) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            Throwable throwable = null;
            try {
                if (karel == null) {
                    this.main();
                } else {
                    karel.run();
                    this.setStatus("Finished running.");
                }
                this.world.setRepaintFlag(true);
                this.world.repaint();
            }
            catch (Exception ex) {
                throwable = ex;
            }
            catch (StackOverflowError err) {
                throwable = err;
            }
            if (throwable == null) {
                this.StateEvent.fire(State.STOPPED);
                continue;
            }
            this.setStatus("Halted due to an error.");
            this.StateEvent.fire(State.ERROR);
            if (this.errorDialog == null) {
                this.errorDialog = new KarelErrorDialog(this);
            }
            if ((errorMessage = throwable.getMessage()) == null || errorMessage.isEmpty()) {
                errorMessage = "";
                if (throwable instanceof StackOverflowError) {
                    errorMessage = "Infinite method calls.";
                }
            }
            while (!errorMessage.endsWith("\n\n")) {
                errorMessage = String.valueOf(errorMessage) + "\n";
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytes);
            throwable.printStackTrace(out);
            String stackTrace = bytes.toString();
            this.errorDialog.error(errorMessage, stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalStarted() {
        KarelProgram karelProgram = this;
        synchronized (karelProgram) {
            this.StateEvent.fire(State.RUNNING);
            this.started = true;
            this.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        STOPPED,
        ERROR;

    }
}

