/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.JTFTools;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private String filenamePattern;
    private String filenameDescription;
    private String dir;

    public FileChooserFilter(String path) {
        this(path, null);
    }

    public FileChooserFilter(String path, String desc) {
        if (path == null) {
            path = "";
        }
        if (desc == null) {
            desc = "All files";
        }
        int i = Math.max(path.lastIndexOf("/"), path.lastIndexOf(92));
        this.filenamePattern = path.substring(i + 1);
        String string = this.dir = i != -1 ? path.substring(0, i) : "";
        if (this.dir.isEmpty()) {
            this.dir = System.getProperty("user.dir");
        } else if (!this.dir.startsWith("/")) {
            this.dir = String.valueOf(System.getProperty("user.dir")) + "/" + this.dir;
        }
        this.filenameDescription = desc;
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getPattern() {
        return this.filenamePattern;
    }

    public String getDescription() {
        return this.filenameDescription;
    }

    public boolean accept(File file) {
        if (file.isDirectory() || this.filenamePattern.isEmpty()) {
            return true;
        }
        StringTokenizer stringtokenizer = new StringTokenizer(this.filenamePattern, ";");
        while (stringtokenizer.hasMoreTokens()) {
            String s = stringtokenizer.nextToken();
            if (s.length() <= 0 || !JTFTools.matchFilenamePattern(file.getName(), s)) continue;
            return true;
        }
        return false;
    }
}

