/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.util.FileChooserFilter;

public class JBEFileFilter
extends FileChooserFilter {
    private String dir;

    public JBEFileFilter(String path) {
        super(JBEFileFilter.getPattern(path));
        int i = Math.max(path.lastIndexOf("/"), path.lastIndexOf(92));
        this.dir = i == -1 ? "" : path.substring(0, i);
        String str = path.substring(i + 1);
        if (!JBEFileFilter.isPattern(str)) {
            this.dir = String.valueOf(this.dir) + str;
        }
        if (this.dir.isEmpty()) {
            this.dir = System.getProperty("user.dir");
        } else if (!this.dir.startsWith("/")) {
            this.dir = String.valueOf(System.getProperty("user.dir")) + "/" + this.dir;
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    private static String getPattern(String paramString) {
        int i = Math.max(paramString.lastIndexOf("/"), paramString.lastIndexOf(92));
        String str = paramString.substring(i + 1);
        return JBEFileFilter.isPattern(str) ? str : null;
    }

    private static boolean isPattern(String paramString) {
        int i = 0;
        while (i < paramString.length()) {
            switch (paramString.charAt(i)) {
                case '*': 
                case ';': 
                case '?': 
                case '[': 
                case ']': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

