/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import stanford.spl.UrlDownloader;
import stanford.spl.Version;

public class LibraryUpdater {
    private static final boolean AUTO_DOWNLOAD = false;
    private static final String LIBRARY_FOLDER_URL = "http://stanford.edu/~stepp/cppdoc/";
    private static final String SPL_JAR_VERSION_URL = "http://stanford.edu/~stepp/cppdoc/CURRENTVERSION_SPLJAR.txt";
    private static final String CPP_ZIP_VERSION_URL = "http://stanford.edu/~stepp/cppdoc/CURRENTVERSION_CPPLIB.txt";
    private static final String CPP_ZIP_FILENAME = "StanfordCPPLib.zip";
    private static final String CPP_ZIP_URL = "http://stanford.edu/~stepp/cppdoc/StanfordCPPLib.zip";
    private static final String SPL_JAR_FILENAME = "spl.jar";
    private static final String SPL_JAR_URL = "http://stanford.edu/~stepp/cppdoc/spl.jar";

    public boolean checkForUpdates() {
        return this.checkForUpdates(null);
    }

    public boolean checkForUpdates(Component parent) {
        boolean outOfDate;
        String currentVersion = Version.isJavaProject() ? Version.getLibraryVersion() : Version.getCppLibraryVersion();
        String latestVersionUrl = Version.isJavaProject() ? SPL_JAR_VERSION_URL : CPP_ZIP_VERSION_URL;
        UrlDownloader downloader = UrlDownloader.getInstance();
        String latestVersion = "";
        try {
            latestVersion = downloader.download(latestVersionUrl);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(parent, "Unable to look up latest version from web: " + ioe.toString());
            return false;
        }
        currentVersion = currentVersion.trim().replace("-", "/");
        latestVersion = latestVersion.trim().replace("-", "/");
        boolean bl = outOfDate = currentVersion.compareTo(latestVersion) < 0;
        if (!outOfDate) {
            JOptionPane.showMessageDialog(parent, "This project already has the latest version \nof the Stanford libraries (" + currentVersion + ").");
            return false;
        }
        String outOfDateMessage = "There is an updated version of the Stanford libraries available.\n\nThis project's library version: " + currentVersion + "\n" + "Current newest library version: " + latestVersion + "\n";
        outOfDateMessage = String.valueOf(outOfDateMessage) + "Go to http://stanford.edu/~stepp/cppdoc/ to get the new version.";
        JOptionPane.showMessageDialog(parent, outOfDateMessage);
        return false;
    }

    private File chooseLibFile(Component parent, String libFileName, boolean dirOnly) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (dirOnly) {
            fileChooser.setFileSelectionMode(1);
        } else {
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f != null && f.getName().endsWith(".jar");
                }

                public String getDescription() {
                    return "Java Archives (*.jar)";
                }
            });
        }
        int result = fileChooser.showSaveDialog(parent);
        if (result != 0) {
            return null;
        }
        File selectedDir = fileChooser.getSelectedFile();
        if (selectedDir == null || !selectedDir.exists() || !selectedDir.isDirectory()) {
            return null;
        }
        File libOutputFileToUse = new File(selectedDir, libFileName);
        return libOutputFileToUse;
    }
}

