/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.program;

import acm.program.CommandLineProgram;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CommandLineProgramMarty
extends CommandLineProgram {
    protected Boolean isApplet = null;

    protected boolean isApplet() {
        if (this.isApplet == null) {
            try {
                this.isApplet = false;
                if (System.getSecurityManager() != null) {
                    this.isApplet = true;
                } else {
                    File currentDir = new File(System.getProperty("user.dir"));
                    currentDir.exists();
                }
            }
            catch (SecurityException sex) {
                this.isApplet = true;
            }
        }
        return this.isApplet;
    }

    protected boolean fileExists(String filename) throws IOException {
        return this.fileExistsOnDisk(filename) || this.fileExistsInsideJAR(filename);
    }

    protected boolean fileExistsInsideJAR(String filename) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(filename);
        if (stream == null) {
            return false;
        }
        stream.close();
        return true;
    }

    protected boolean fileExistsOnDisk(String filename) throws IOException {
        File file;
        block5: {
            if (this.isApplet()) {
                return false;
            }
            file = new File(filename);
            if (!file.exists()) break block5;
            return true;
        }
        try {
            file = new File("../" + filename);
            if (file.exists()) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    protected InputStream openFile(String filename) throws IOException {
        if (!this.isApplet() && this.fileExistsOnDisk(filename)) {
            return this.openFileFromDisk(filename);
        }
        if (this.fileExistsInsideJAR(filename)) {
            return this.openFileFromJAR(filename);
        }
        throw new FileNotFoundException(filename);
    }

    protected InputStream openFileFromDisk(String filename) throws IOException {
        File file = new File(filename);
        try {
            if (file.exists()) {
                return new BufferedInputStream(new FileInputStream(file));
            }
            file = new File("../" + filename);
            if (file.exists()) {
                return new BufferedInputStream(new FileInputStream(file));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        throw new FileNotFoundException(filename);
    }

    protected InputStream openFileFromJAR(String filename) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(filename);
        if (stream == null) {
            throw new FileNotFoundException(filename);
        }
        return new BufferedInputStream(stream);
    }

    protected String readEntireFile(String filename) throws IOException {
        return this.readEntireStream(this.openFile(filename));
    }

    protected String readEntireStream(InputStream stream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = stream.read()) != -1) {
            sb.append((char)ch);
        }
        return sb.toString();
    }
}

