/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.ConsoleModel;
import acm.io.ConsoleReader;
import acm.io.ConsoleWriter;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.io.StandardConsoleModel;
import acm.io.SystemConsole;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JMenuItem;

public class IOConsole
extends Container
implements IOModel {
    private static final long serialVersionUID = 0L;
    public static final IOConsole SYSTEM_CONSOLE = new SystemConsole();
    protected static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int MINIMUM_CONSOLE_WIDTH = 50;
    protected static final int MINIMUM_CONSOLE_HEIGHT = 40;
    private static final String[] CONSOLE_MENU_ACTIONS = new String[]{"Save", "Save As", "Print Console", "Script", "Cut", "Copy", "Paste", "Select All"};
    private ConsoleModel consoleModel = this.createConsoleModel();
    private boolean exceptionOnError;
    private Color inputColor;
    private int inputStyle;
    private Color errorColor;
    private int errorStyle;
    private BufferedReader reader;
    private PrintWriter writer;
    private File file;
    private ProgramMenuBar menuBar;

    public IOConsole() {
        this.consoleModel.setConsole(this);
        this.setBackground(Color.WHITE);
        this.setInputColor(Color.BLUE);
        this.setInputStyle(1);
        this.setErrorColor(Color.RED);
        this.setErrorStyle(1);
        this.setFont(JTFTools.getStandardFont(DEFAULT_FONT));
        Component localComponent = this.consoleModel.getConsolePane();
        if (localComponent != null) {
            this.setLayout(new BorderLayout());
            this.add(localComponent, "Center");
        }
        this.reader = null;
        this.writer = null;
        this.exceptionOnError = false;
    }

    public void clear() {
        this.consoleModel.clear();
    }

    public ConsoleModel getConsoleModel() {
        return this.consoleModel;
    }

    public void print(String paramString) {
        this.getWriter().print(paramString);
    }

    public final void print(boolean paramBoolean) {
        this.print("" + paramBoolean);
    }

    public final void print(char paramChar) {
        this.print("" + paramChar);
    }

    public final void print(double paramDouble) {
        this.print("" + paramDouble);
    }

    public final void print(float paramFloat) {
        this.print("" + paramFloat);
    }

    public final void print(int paramInt) {
        this.print("" + paramInt);
    }

    public final void print(long paramLong) {
        this.print("" + paramLong);
    }

    public final void print(Object paramObject) {
        this.print("" + paramObject);
    }

    public void println() {
        this.getWriter().println();
    }

    public void println(String paramString) {
        this.getWriter().println(paramString);
    }

    public final void println(boolean paramBoolean) {
        this.println("" + paramBoolean);
    }

    public final void println(char paramChar) {
        this.println("" + paramChar);
    }

    public final void println(double paramDouble) {
        this.println("" + paramDouble);
    }

    public final void println(float paramFloat) {
        this.println("" + paramFloat);
    }

    public final void println(int paramInt) {
        this.println("" + paramInt);
    }

    public final void println(long paramLong) {
        this.println("" + paramLong);
    }

    public final void println(Object paramObject) {
        this.println("" + paramObject);
    }

    public void showErrorMessage(String paramString) {
        this.consoleModel.print(paramString, 2);
        this.consoleModel.print("\n", 2);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String paramString) {
        if (paramString != null) {
            paramString = this.appendSpace(paramString);
            this.print(paramString);
        }
        this.consoleModel.requestFocus();
        try {
            return this.getReader().readLine();
        }
        catch (IOException localIOException) {
            throw new ErrorException(localIOException);
        }
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int paramInt1, int paramInt2) {
        return this.readInt(null, paramInt1, paramInt2);
    }

    public final int readInt(String paramString) {
        return this.readInt(paramString, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String paramString, int paramInt1, int paramInt2) {
        String str1 = null;
        while (true) {
            String str2 = this.readLine(paramString);
            try {
                int i = Integer.parseInt(str2);
                if (i >= paramInt1 && i <= paramInt2) {
                    return i;
                }
                str1 = "Value is outside the range [" + paramInt1 + ":" + paramInt2 + "]";
            }
            catch (NumberFormatException localNumberFormatException) {
                str1 = "Illegal numeric format";
            }
            this.showErrorMessage(str1);
            if (paramString != null) continue;
            paramString = "Retry: ";
        }
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double paramDouble1, double paramDouble2) {
        return this.readDouble(null, paramDouble1, paramDouble2);
    }

    public final double readDouble(String paramString) {
        return this.readDouble(paramString, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String paramString, double paramDouble1, double paramDouble2) {
        String str1 = null;
        while (true) {
            String str2 = this.readLine(paramString);
            try {
                double d = Double.valueOf(str2);
                if (d >= paramDouble1 && d <= paramDouble2) {
                    return d;
                }
                str1 = "Value is outside the range [" + paramDouble1 + ":" + paramDouble2 + "]";
            }
            catch (NumberFormatException localNumberFormatException) {
                str1 = "Illegal numeric format";
            }
            this.showErrorMessage(str1);
            if (paramString != null) continue;
            paramString = "Retry: ";
        }
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String paramString) {
        return this.readBoolean(paramString, "true", "false");
    }

    public boolean readBoolean(String paramString1, String paramString2, String paramString3) {
        while (true) {
            String str;
            if ((str = this.readLine(paramString1)) == null) {
                throw new ErrorException("End of file encountered");
            }
            if (str.equalsIgnoreCase(paramString2)) {
                return true;
            }
            if (str.equalsIgnoreCase(paramString3)) {
                return false;
            }
            if (this.exceptionOnError) {
                throw new ErrorException("Illegal boolean format");
            }
            this.showErrorMessage("Illegal boolean format");
            if (paramString1 != null) continue;
            paramString1 = "Retry: ";
        }
    }

    protected String appendSpace(String s) {
        if (!(s = String.valueOf(s)).endsWith(" ")) {
            s = String.valueOf(s) + " ";
        }
        return s;
    }

    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new ConsoleReader(this.consoleModel));
        }
        return this.reader;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(new ConsoleWriter(this.consoleModel));
        }
        return this.writer;
    }

    public void setExceptionOnError(boolean paramBoolean) {
        this.exceptionOnError = paramBoolean;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public void setInputStyle(int paramInt) {
        this.inputStyle = paramInt;
        this.consoleModel.setInputStyle(paramInt);
    }

    public int getInputStyle() {
        return this.inputStyle;
    }

    public void setInputColor(Color paramColor) {
        this.inputColor = paramColor;
        this.consoleModel.setInputColor(paramColor);
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setErrorStyle(int paramInt) {
        this.errorStyle = paramInt;
        this.consoleModel.setErrorStyle(paramInt);
    }

    public int getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorColor(Color paramColor) {
        this.errorColor = paramColor;
        this.consoleModel.setErrorColor(paramColor);
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setFont(String paramString) {
        this.setFont(JTFTools.decodeFont(paramString, this.getFont()));
    }

    public void setInputScript(BufferedReader paramBufferedReader) {
        this.consoleModel.setInputScript(paramBufferedReader);
    }

    public BufferedReader getInputScript() {
        return this.consoleModel.getInputScript();
    }

    public void cut() {
        this.consoleModel.cut();
    }

    public void copy() {
        this.consoleModel.copy();
    }

    public void paste() {
        this.consoleModel.paste();
    }

    public void selectAll() {
        this.consoleModel.selectAll();
    }

    public void save() {
        FileWriter localFileWriter = null;
        while (localFileWriter == null) {
            Object localObject;
            try {
                if (this.file == null) {
                    Frame localFrame = JTFTools.getEnclosingFrame(this);
                    if (localFrame == null) {
                        return;
                    }
                    localObject = System.getProperty("user.dir");
                    FileDialog localFileDialog = new FileDialog(localFrame, "Save Console As", 1);
                    localFileDialog.setDirectory((String)localObject);
                    localFileDialog.setVisible(true);
                    String str = localFileDialog.getFile();
                    if (str == null) {
                        return;
                    }
                    this.file = new File(localFileDialog.getDirectory(), str);
                }
                localFileWriter = new FileWriter(this.file);
                this.save(localFileWriter);
                localFileWriter.close();
                Platform.setFileTypeAndCreator(this.file, "TEXT", "ttxt");
            }
            catch (IOException localIOException) {
                localObject = new IODialog(this);
                ((IODialog)localObject).showErrorMessage(localIOException.getMessage());
            }
        }
    }

    public void saveAs() {
        this.file = null;
        this.save();
    }

    public void save(Writer paramWriter) {
        try {
            paramWriter.write(this.consoleModel.getText());
        }
        catch (IOException localIOException) {
            throw new ErrorException(localIOException);
        }
    }

    public void printConsole() {
        Frame localFrame = JTFTools.getEnclosingFrame(this);
        if (localFrame == null) {
            return;
        }
        PrintJob localPrintJob = this.getToolkit().getPrintJob(localFrame, "Console", null);
        if (localPrintJob == null) {
            return;
        }
        this.printConsole(localPrintJob);
        localPrintJob.end();
    }

    public void printConsole(PrintJob paramPrintJob) {
        this.consoleModel.print(paramPrintJob);
    }

    public void script() {
        Frame localFrame = JTFTools.getEnclosingFrame(this);
        FileDialog localFileDialog = new FileDialog(localFrame, "Input Script", 0);
        localFileDialog.setDirectory(System.getProperty("user.dir"));
        localFileDialog.setVisible(true);
        String str1 = localFileDialog.getDirectory();
        String str2 = localFileDialog.getFile();
        if (str2 != null) {
            try {
                FileReader localFileReader = new FileReader(new File(new File(str1), str2));
                this.setInputScript(new BufferedReader(localFileReader));
            }
            catch (IOException localIOException) {
                throw new ErrorException(localIOException);
            }
        }
    }

    public void setMenuBar(ProgramMenuBar paramProgramMenuBar) {
        this.menuBar = paramProgramMenuBar;
        this.consoleModel.setMenuBar(paramProgramMenuBar);
    }

    public ProgramMenuBar getMenuBar() {
        return this.menuBar;
    }

    public boolean menuAction(ActionEvent paramActionEvent) {
        String str = paramActionEvent.getActionCommand();
        if (str.equals("Cut")) {
            this.cut();
            return true;
        }
        if (str.equals("Copy")) {
            this.copy();
            return true;
        }
        if (str.equals("Paste")) {
            this.paste();
            return true;
        }
        if (str.equals("Select All")) {
            this.selectAll();
            return true;
        }
        if (str.equals("Save")) {
            this.save();
            return true;
        }
        if (str.equals("Save As")) {
            this.saveAs();
            return true;
        }
        if (str.equals("Script")) {
            this.script();
            return true;
        }
        if (str.equals("Print Console")) {
            this.printConsole();
            return true;
        }
        if (str.equals("Clear Console")) {
            this.clear();
            return true;
        }
        return false;
    }

    public boolean isConsoleMenuItem(JMenuItem paramJMenuItem) {
        String str = paramJMenuItem.getActionCommand();
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < CONSOLE_MENU_ACTIONS.length) {
            if (str.equals(CONSOLE_MENU_ACTIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateMenuBar(ProgramMenuBar paramProgramMenuBar) {
        for (JMenuItem localJMenuItem : paramProgramMenuBar) {
            if (this.isConsoleMenuItem(localJMenuItem)) {
                localJMenuItem.setEnabled(true);
                continue;
            }
            localJMenuItem.setEnabled(!paramProgramMenuBar.isFocusedItem(localJMenuItem));
        }
    }

    public void setBackground(Color paramColor) {
        Component localComponent = this.consoleModel.getTextPane();
        if (localComponent != null) {
            localComponent.setBackground(paramColor);
        }
        super.setBackground(paramColor);
    }

    public void setForeground(Color paramColor) {
        Component localComponent = this.consoleModel.getTextPane();
        if (localComponent != null) {
            localComponent.setForeground(paramColor);
        }
        super.setForeground(paramColor);
    }

    public void setFont(Font paramFont) {
        paramFont = JTFTools.getStandardFont(paramFont);
        Component localComponent = this.consoleModel.getTextPane();
        if (localComponent != null) {
            localComponent.setFont(paramFont);
        }
        super.setFont(paramFont);
    }

    public void requestFocus() {
        this.consoleModel.requestFocus();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 40);
    }

    protected ConsoleModel createConsoleModel() {
        return new StandardConsoleModel();
    }
}

