/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.util;

public final class SystemProperties {
    private SystemProperties() {
    }

    public static boolean hasSystemProperty(String name) {
        String prop = SystemProperties.getSystemProperty(name);
        return prop != null && !prop.isEmpty();
    }

    public static String getSystemProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException se) {
            return "";
        }
    }

    public static int getSystemPropertyInt(String name) {
        return Integer.parseInt(SystemProperties.getSystemProperty(name));
    }

    public static int getSystemPropertyInt(String name, int defaultValue) {
        if (SystemProperties.hasSystemProperty(name)) {
            return SystemProperties.getSystemPropertyInt(name);
        }
        return defaultValue;
    }

    public static double getSystemPropertyDouble(String name) {
        return Double.parseDouble(SystemProperties.getSystemProperty(name));
    }

    public static double getSystemPropertyDouble(String name, double defaultValue) {
        if (SystemProperties.hasSystemProperty(name)) {
            return SystemProperties.getSystemPropertyDouble(name);
        }
        return defaultValue;
    }

    public static boolean getSystemPropertyBoolean(String name) {
        return SystemProperties.getSystemPropertyBoolean(name, false);
    }

    public static boolean getSystemPropertyBoolean(String name, boolean defaultValue) {
        if (SystemProperties.hasSystemProperty(name)) {
            String prop = String.valueOf(SystemProperties.getSystemProperty(name)).toLowerCase().intern();
            return prop != null && (prop == "true" || prop == "t" || prop == "1" || prop == "on" || prop == "yes" || prop == "y");
        }
        return defaultValue;
    }

    public static void setSystemProperty(String name, String value) {
        try {
            System.setProperty(name, value);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

