/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ImageSaver;
import acm.util.MediaTools;
import java.awt.Image;

class PICTImageSaver
extends ImageSaver {
    private static final int OP_CLIP = 1;
    private static final int OP_VERSION = 17;
    private static final int OP_DEF_HILITE = 30;
    private static final int OP_SHORT_LINE = 34;
    private static final int OP_DIRECT_BITS_RECT = 154;
    private static final int OP_SHORT_COMMENT = 160;
    private static final int OP_LONG_COMMENT = 161;
    private static final int OP_END_PICT = 255;
    private static final int OP_HEADER = 3072;
    private static final int PS_BEGIN = 190;
    private static final int PS_END = 191;
    private static final int PS_HANDLE = 192;
    private static final int PS_DICT_SIZE = 500;
    private static final int VERSION = 767;
    private static final int PICT_PADDING = 512;
    private static final int RGB_DIRECT = 16;
    private static final int SRC_COPY = 0;
    private int[][] pixels;
    private String[] psPreview;
    private int width;
    private int height;
    private int rowBytes;
    private boolean paddingFlag = true;

    PICTImageSaver() {
    }

    public void saveImage(Image image) {
        this.pixels = MediaTools.getPixelArray(image);
        Object object = image.getProperty("PSPreview", null);
        this.psPreview = object instanceof String[] ? (String[])object : null;
        this.width = this.pixels[0].length;
        this.height = this.pixels.length;
        this.rowBytes = 4 * this.width;
        if (this.paddingFlag) {
            this.dumpPadding();
        }
        this.dumpHeader();
        this.dumpDefHilite();
        this.dumpClipRegion();
        this.dumpBoundsMarkers();
        if (this.psPreview != null) {
            this.dumpShort(160);
            this.dumpShort(190);
        }
        this.dumpDirectBitsRect();
        if (this.psPreview != null) {
            this.dumpPSPreview();
            this.dumpShort(160);
            this.dumpShort(191);
        }
        this.dumpEndPict();
    }

    public void setPaddingFlag(boolean bl) {
        this.paddingFlag = bl;
    }

    private void dumpPadding() {
        for (int i = 0; i < 512; ++i) {
            this.dumpByte(0);
        }
    }

    private void dumpHeader() {
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(17);
        this.dumpShort(767);
        this.dumpShort(3072);
        this.dumpShort(65534);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpLong(0);
    }

    private void dumpDefHilite() {
        this.dumpShort(30);
    }

    private void dumpClipRegion() {
        this.dumpShort(1);
        this.dumpShort(10);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
    }

    private void dumpBoundsMarkers() {
        this.dumpShort(34);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(34);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
    }

    private void dumpDirectBitsRect() {
        this.dumpShort(154);
        this.dumpPixMap();
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpPixelData();
    }

    private void dumpPixMap() {
        this.dumpLong(255);
        this.dumpShort(this.rowBytes | 0x8000);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpShort(4);
        this.dumpLong(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(16);
        this.dumpShort(32);
        this.dumpShort(3);
        this.dumpShort(8);
        this.dumpLong(0);
        this.dumpLong(0);
        this.dumpLong(0);
    }

    private void dumpEndPict() {
        this.dumpShort(255);
    }

    private void dumpPixelData() {
        int n = 0;
        byte[] byArray = new byte[this.rowBytes];
        for (int i = 0; i < this.height; ++i) {
            int n2 = this.packScanLine(byArray, this.pixels[i]);
            if (this.rowBytes > 250) {
                this.dumpShort(n2);
                n += 2;
            } else {
                this.dumpByte(n2);
                ++n;
            }
            for (int j = 0; j < n2; ++j) {
                this.dumpByte(byArray[j]);
            }
            n += n2;
        }
        if (n % 2 == 1) {
            this.dumpByte(0);
        }
    }

    private int packScanLine(byte[] byArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2;
            int n3;
            int n4;
            char c = "RGB".charAt(i);
            int n5 = n;
            int n6 = n + 1;
            int n7 = 0;
            while (n7 < this.width) {
                n4 = this.getPixelComponent(nArray[n7++], c);
                byArray[n6++] = (byte)n4;
                n3 = 0;
                if (n7 < this.width) {
                    int n8 = this.getPixelComponent(nArray[n7], c);
                    int n9 = n3 = n4 == n8 ? 1 : 0;
                    if (n3 != 0) {
                        for (n2 = 1; n2 < 128 && n7 < this.width && n4 == (n8 = this.getPixelComponent(nArray[n7], c)); ++n2, ++n7) {
                        }
                    } else {
                        while (n2 < 128 && n7 < this.width) {
                            n8 = this.getPixelComponent(nArray[n7], c);
                            if (n4 == n8) {
                                --n6;
                                --n2;
                                --n7;
                                break;
                            }
                            byArray[n6++] = (byte)n8;
                            n4 = n8;
                            ++n2;
                            ++n7;
                        }
                    }
                }
                byArray[n] = n3 != 0 ? (byte)(0x80 | 129 - n2) : (byte)(n2 - 1);
                n = n6++;
            }
            if (n - n5 <= this.width + this.width / 128) continue;
            n4 = this.width;
            n = n5;
            for (n2 = 0; n2 < this.width; ++n2) {
                if (n2 % 128 == 0) {
                    n3 = n4 > 128 ? 128 : n4;
                    byArray[n++] = (byte)(n3 - 1);
                    n4 -= n3;
                }
                byArray[n++] = (byte)this.getPixelComponent(nArray[n2], c);
            }
        }
        return n;
    }

    private void dumpPSPreview() {
        this.addPSComment("/dictCount countdictstack def");
        this.addPSComment("/opCount count 1 sub def");
        this.addPSComment("500 dict begin");
        this.addPSComment("/showpage {} def");
        this.addPSComment("0 setgray 0 setlinecap");
        this.addPSComment("1 setlinewidth 0 setlinejoin");
        this.addPSComment("10 setmiterlimit [] 0 setdash");
        this.addPSComment("/languagelevel where {");
        this.addPSComment("  pop languagelevel");
        this.addPSComment("  1 ne { false setstrokeadjust false setoverprint } if");
        this.addPSComment("} if");
        this.addPSComment("gsave");
        this.addPSComment("clippath pathbbox");
        this.addPSComment("pop pop " + this.height + " add translate");
        this.addPSComment("1 -1 scale");
        for (int i = 0; i < this.psPreview.length; ++i) {
            this.addPSComment(this.psPreview[i]);
        }
        this.addPSComment("grestore");
        this.addPSComment("end");
        this.addPSComment("count opCount sub {pop} repeat");
        this.addPSComment("countdictstack dictCount sub {end} repeat");
    }

    private void addPSComment(String string) {
        if (string.length() % 2 == 0) {
            string = string + " ";
        }
        this.dumpShort(161);
        this.dumpShort(192);
        this.dumpShort(string.length() + 1);
        for (int i = 0; i < string.length(); ++i) {
            this.dumpByte(string.charAt(i));
        }
        this.dumpByte(13);
    }
}

