/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.io.StandardConsoleModel;
import acm.program.Program;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class AbstractConsoleProgram
extends Program {
    private static final int DEFAULT_LINE_HEIGHT = 16;

    private JScrollPane getScrollPane() {
        IOConsole console = this.getConsole();
        StandardConsoleModel model = (StandardConsoleModel)console.getConsoleModel();
        return model.getScrollPane();
    }

    public void historyDown() {
        IOConsole console = this.getConsole();
        StandardConsoleModel model = (StandardConsoleModel)console.getConsoleModel();
        model.historyDown();
    }

    public void historyUp() {
        IOConsole console = this.getConsole();
        StandardConsoleModel model = (StandardConsoleModel)console.getConsoleModel();
        model.historyUp();
    }

    private int scrollPageHeight() {
        JScrollPane scroll = this.getScrollPane();
        if (scroll != null && scroll.getVerticalScrollBar() != null) {
            return scroll.getHeight();
        }
        return 0;
    }

    private int scrollLineHeight() {
        Font programFont = this.getFont();
        if (programFont == null) {
            return 16;
        }
        FontMetrics fm = this.getFontMetrics(programFont);
        return fm.getHeight();
    }

    private void scrollBy(int dy) {
        int y;
        JScrollPane scroll = this.getScrollPane();
        if (scroll == null) {
            return;
        }
        JScrollBar bar = scroll.getVerticalScrollBar();
        if (bar == null) {
            return;
        }
        int min = scroll.getVerticalScrollBar().getMinimum();
        int max = scroll.getVerticalScrollBar().getMaximum();
        if (dy == Integer.MIN_VALUE) {
            y = min;
        } else if (dy == Integer.MAX_VALUE) {
            y = max;
        } else {
            y = bar.getValue() + dy;
            y = Math.max(min, y);
            y = Math.min(max, y);
        }
        bar.setValue(y);
    }

    public void scrollToTop() {
        this.scrollBy(Integer.MIN_VALUE);
    }

    public void scrollToBottom() {
        this.scrollBy(Integer.MAX_VALUE);
    }

    public void scrollPageUp() {
        this.scrollBy(-this.scrollPageHeight());
    }

    public void scrollPageDown() {
        this.scrollBy(this.scrollPageHeight());
    }

    public void scrollLineUp() {
        this.scrollBy(-this.scrollLineHeight());
    }

    public void scrollLineDown() {
        this.scrollBy(this.scrollLineHeight());
    }
}

