/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.util.ErrorException;
import acm.util.TokenScanner;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import stanford.spl.JBECommand;
import stanford.spl.JavaBackEnd;

class Regex_match
extends JBECommand {
    Regex_match() {
    }

    public static String pipeDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee);
        }
        return s;
    }

    public static String pipeEncode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee);
        }
        return s;
    }

    public static String readEncodedString(TokenScanner paramTokenScanner) {
        char ch;
        String s = "";
        if ((char)paramTokenScanner.getChar() != '\"') {
            throw new ErrorException("quoted string must start with \" character");
        }
        while ((ch = (char)paramTokenScanner.getChar()) != '\"' && ch >= '\u0000') {
            s = String.valueOf(s) + ch;
        }
        return s;
    }

    public void execute(TokenScanner paramTokenScanner, JavaBackEnd paramJavaBackEnd) {
        paramTokenScanner.verifyToken("(");
        String s = Regex_match.readEncodedString(paramTokenScanner);
        s = Regex_match.pipeDecode(s);
        paramTokenScanner.verifyToken(",");
        String regexp = Regex_match.readEncodedString(paramTokenScanner);
        regexp = Regex_match.pipeDecode(regexp);
        paramTokenScanner.verifyToken(")");
        boolean result = s.matches(regexp);
        System.out.println("result:" + result);
        System.out.flush();
    }
}

