/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.FinalPathElement;
import acm.graphics.GRectangle;
import acm.graphics.PathElement;
import acm.graphics.PathState;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ArrayList;

class PathList
implements Serializable {
    private static final PathElement FINAL_PATH_ELEMENT = new FinalPathElement();
    private ArrayList<PathElement> path = new ArrayList();

    public synchronized void add(PathElement pathElement) {
        this.path.add(pathElement);
    }

    public synchronized void add(PathElement pathElement, PathElement pathElement2) {
        this.path.add(pathElement);
        this.path.add(pathElement2);
    }

    public synchronized void remove(PathElement pathElement) {
        this.path.remove(pathElement);
    }

    public synchronized void clear() {
        this.path.clear();
    }

    public int getElementCount() {
        return this.path.size();
    }

    public PathElement getElement(int n) {
        return this.path.get(n);
    }

    public synchronized GRectangle getBounds(PathState pathState) {
        GRectangle gRectangle = new GRectangle(-1.0, -1.0, -1.0, -1.0);
        int n = this.path.size();
        for (int i = 0; i < n; ++i) {
            PathElement pathElement = this.path.get(i);
            pathElement.updateBounds(gRectangle, pathState);
        }
        return gRectangle;
    }

    public synchronized void mapPaint(Graphics2D graphics2D, PathState pathState) {
        int n = this.path.size();
        for (int i = 0; i < n; ++i) {
            PathElement pathElement = this.path.get(i);
            pathElement.paint(graphics2D, pathState);
        }
        FINAL_PATH_ELEMENT.paint(graphics2D, pathState);
    }
}

