import random
import numpy as np
import math
from scipy import stats

def makeRandomPopulation(n):
	pmf = getRandomPmf()
	samples = samplePmf(pmf, n)
	return samples, sampleVariance(samples)

def makeRandomPopulation2(n):
	pmf = getRandomPmf()
	samples = stats.norm.rvs(loc=10, scale=0.1, size=n)
	return samples, sampleVariance(samples)

def makeModalPopulation(n):
	pmf = getModalPmf()
	samples = samplePmf(pmf, n)
	return samples, sampleVariance(samples)

def samplePmf(pmf, n):
	cdf = makeCdf(pmf)
	pop = []
	for i in range(n):
		v = drawSample(cdf)
		pop.append(v)
	return pop

def getModalPmf():
	unnormalized = []
	currValue = 0
	derivative = 0
	secondDerivative = random.random()
	for i in range(100):
		if i % 25 == 0:
			secondDerivative = random.random()
			secondDerivative *= -1
		derivative += secondDerivative
		currValue += derivative
		if currValue < 0:
			secondDerivative = random.random() - 0.5
			derivative = 0
			currValue = 0
		unnormalized.append(currValue)
	total = sum(unnormalized)
	dist = []
	for i in range(len(unnormalized)):
		dist.append(unnormalized[i] / total)
	return dist

def getRandomPmf():
	unnormalized = []
	for i in range(100):
		unnormalized.append(random.random())
	total = sum(unnormalized)
	dist = []
	for i in range(len(unnormalized)):
		dist.append(unnormalized[i] / total)
	return dist

def makeCdf(pmf):
	cdf = []
	cumulative = 0
	for i in range(len(pmf)):
		cumulative += pmf[i]
		cdf.append(cumulative)
	return cdf

def drawSample(cdf):
	y = random.random()
	v = binarySearch(cdf, y)
	return v

# This is the definition of the variance of an
# entire population.
def sampleVariance(data):
	sampleMean = np.mean(data)
	n = len(data)
	total = 0
	for i in range(n):
		d = data[i]
		total += math.pow(d - sampleMean, 2)
	return float(total)/ (n-1)

def binarySearch(cdf, goalY):
	lowerIndex = 0
	upperIndex = len(cdf)
	while True:
		midIndex = int(lowerIndex + (upperIndex - lowerIndex)/2)
		y = cdf[midIndex]
		#print lowerIndex, midIndex, upperIndex
		if y < goalY:
			lowerIndex = midIndex
		else:
			upperIndex = midIndex
		spread = upperIndex - lowerIndex
		if spread == 1:
			if goalY > cdf[lowerIndex]:
				return upperIndex
			else:
				return lowerIndex