/**
 * canMakeOrders() and fulfillOrders() implementation on the midterm review problems.
 * - canMakeOrders() should take in a pantry object and list of cake orders as
 *   input, as structured above, and return a boolean variable that is true if the pantry has
 *   sufficient ingredient amounts to make all the orders, and false otherwise. 
 * - fulfillOrders() should modify the pantry object in place, and decrement as many ingredient 
 * amounts as the cake orders together require, and then also return the modified pantry object.
 */

function canMakeOrders(pantry, cakeOrders){
	// TODO: replace the below with your implementation. you're free to add helper functions also!
	return false;
}

function fulfillOrders(pantry, cakeOrders) {
	// TODO: write your implementation here. you're free to add helper functions also!
}

/* Main program */
function TestGreatBakeOff() {
    for (let i = 0; i < CAKE_BAKING_ARRAYS.length; i++) {
      let pantry = CAKE_BAKING_ARRAYS[i].pantry;
	  let cakeOrders = CAKE_BAKING_ARRAYS[i].cakeOrders;
	  let canMakeAnswer = CAKE_BAKING_ARRAYS[i].canMake;
	  let leftoversAnswer = CAKE_BAKING_ARRAYS[i].leftovers;

	  let canMake = canMakeOrders(pantry, cakeOrders);
	  if (canMake === canMakeAnswer){
		console.log("🍰 canMakeOrders(pantry=" + JSON.stringify(pantry) + ", cakeOrders=" + JSON.stringify(cakeOrders) + ") -> " + canMake + " ✅");
	  } else{
		console.log("🍰 canMakeOrders(pantry=" + JSON.stringify(pantry) + ", cakeOrders=" + JSON.stringify(cakeOrders) + ") -> " + canMake + " ❌ Expected: " + canMakeAnswer);
	  }
	  if (canMakeAnswer){
		let leftovers = fulfillOrders(pantry, cakeOrders);
		if (leftovers !== undefined && checkObjectsSame(leftovers, leftoversAnswer)){
			console.log("🥣 fulfillOrders(pantry=" + JSON.stringify(pantry) + ", cakeOrders=" + JSON.stringify(cakeOrders) + ") -> " + JSON.stringify(leftovers) + " ✅");
		} else{
			console.log("🥣 fulfillOrders(pantry=" + JSON.stringify(pantry) + ", cakeOrders=" + JSON.stringify(cakeOrders) + ") -> " + JSON.stringify(leftovers) + " ❌ Expected: " + JSON.stringify(leftoversAnswer));
		}
	  } else{
		console.log("Note: 🥣 fulfillOrders not called / tested as canMakeOrders should return false");
	  }
	  console.log(""); // add space
	}
}

function checkArraysSame(arr1, arr2){
	if (arr1.length !== arr2.length) return false;
	for (let i = 0; i < arr1.length1; i++){
		if (arr1[i] !== arr2[i]) return false;
	}
	return true;
}

function checkObjectsSame(obj1, obj2){
	let obj1Keys = Object.keys(obj1);
	let obj2Keys = Object.keys(obj2);
	obj1Keys.sort(); // alphabetically
	obj2Keys.sort(); // alphabetically

	//check keys are the same 
	let sameKeys = checkArraysSame(obj1Keys, obj2Keys);
	if (!sameKeys) return false;

	// check if the values are the same 
	for (let key in obj1){
		if (obj1[key] !== obj2[key]) return false;
	}
	return true;
}

const CAKE_BAKING_ARRAYS = [
	{"pantry": {flour: 100, sugar: 50, salt: 20}, 
	"cakeOrders": [{flour: 40, sugar: 20, salt: 10},
		{flour: 30, sugar: 20, salt: 5}],
	"canMake": true,
	"leftovers": {flour: 30, sugar: 10, salt: 5}}, // i.e. expected result

	{"pantry": {flour: 30, sugar: 10, salt: 5}, 
	"cakeOrders": [{flour: 30, sugar: 15, salt: 5, chocolate: 5}],
	"canMake": false,
    "leftovers": {flour: 30, sugar: 10, salt: 5}}, // can't make cake orders, so same as before
];