/*
 * File: magicWand.js
 * -----------------
 * This program implements a magic wand rectangle that follows the user's 
 * mouse in both directions, and continually shoots circular sparks toward the top. 
 */
"use strict";

const GWINDOW_HEIGHT = 400;
const GWINDOW_WIDTH = 400;
const WAND_WIDTH = 10;
const WAND_HEIGHT = 60;
const SPARK_TIME_STEP = 2; // in milliseconds 
const LAUNCH_TIME_STEP = 10; // in milliseconds
const SPARK_Y_VELOCITY = -10;
const SPARK_RADIUS = 5;

function magicWand(){
    let gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
    let wand = GRect(WAND_WIDTH, WAND_HEIGHT);
    wand.setFilled(true);
    wand.setColor("brown");
    gw.add(wand, 0, 0); // add to top-left corner of the screen

    /* the top-left corner of the magic wand moves with the user's mouse */
    function moveWand(e){
        wand.setLocation(e.getX(), e.getY());
    }
    gw.addEventListener("mousemove", moveWand);

    function launchFlyingSpark(){
        /* creates spark initially with the same top-left coordinates as wand */
        let spark = GOval(wand.getX(), wand.getY(), SPARK_RADIUS * 2, SPARK_RADIUS * 2);
        spark.setFilled(true);
        spark.setColor("yellow");
        gw.add(spark);

        /* creates animation to send this spark to the top of the screen */
        function moveSparkUp(){
            spark.move(0, SPARK_Y_VELOCITY);
            if (spark.getY() < 0){ /* remove and clear animation when at top */
                gw.remove(spark);
                clearInterval(flyingTimer);
            }
        }
        let flyingTimer = setInterval(moveSparkUp, SPARK_TIME_STEP);
    }
     /* creates a new flying spark every LAUNCH_TIME_STEP milliseconds */ 
    let sparksTimer = setInterval(launchFlyingSpark, LAUNCH_TIME_STEP);
}