/**
 * removeDoubledLetters() implementation on the midterm review problems.
 * The function takes a string and returns a new string with all doubled 
 * consecutive letters in the string replaced by a single letter.
 */

function removeDoubledLetters(str) {
	let result = "";
	for (let i = 0; i < str.length; i++){
		let currLetter = str[i];
		// check if starting letter or not same as previous
		if (i === 0 || currLetter !== str[i - 1]){
			result += currLetter;
		}
	}
	return result;
}

/* Main program */
function TestRemoveDoubledLetters() {
	for (let i = 0; i < STRINGS.length; i++) {
		let str = STRINGS[i];
		let output = removeDoubledLetters(str);
		if (output === ANSWERS[i]){
			console.log("📚 removeDoubledLetters(\"" + str + "\") -> \"" + output + "\". Test passed! ✅");
		} else{
			console.log("📚 removeDoubledLetters(\"" + str + "\") -> \"" + output + "\". ❌ Expected: \"" + ANSWERS[i] + "\"");
		}
	}
}

const STRINGS = ["bookkeeper", "zzzz", "veryycoool"];
const ANSWERS = ["bokeper", "z", "verycol"];