/**
 * longestVowelStreak() implementation on the midterm review problems.
 * The function takes in a string str and returns the longest number of vowels 
 * that appear in a row. We’ll consider vowels to be only the letters A, E, I, O, U. 
 */

function longestVowelStreak(str) {
	let currentBestStreak = 0;
	let currentStreak = 0;

	for (let i = 0; i < str.length; i++){
		let currLetter = str[i];
		if (isVowel(currLetter)){ // continue current streak of vowels
			currentStreak++;
		} else { // end current streak, see if it beats current best
			if (currentStreak > currentBestStreak) currentBestStreak = currentStreak;
			currentStreak = 0;
		}
	}
	// account for any vowel streak continuing to the end
	if (currentStreak > currentBestStreak) currentBestStreak = currentStreak;
	return currentBestStreak;
}

function isVowel(letter){ // helper function
	return "AEIOU".includes(letter.toUpperCase());
}

/* Main program */
function TestLongestVowelStreak() {
	for (let i = 0; i < STRINGS.length; i++) {
		let str = STRINGS[i];
		let vowelStreak = longestVowelStreak(str);
		if (vowelStreak === VOWEL_STREAKS[i]){
			console.log("removeDoubledLetters(\"" + str + "\") -> " + vowelStreak + ". Test passed! ✅");
		} else{
			console.log("removeDoubledLetters(\"" + str + "\") -> " + vowelStreak + ". ❌ Expected: " + VOWEL_STREAKS[i]);
		}
	}
}

const STRINGS = ["syzygy", "QUEUE", "Jouaeint means play in French", "", "ni shi wo de xiao ya xiao ping guo"];
const VOWEL_STREAKS = [0, 4, 5, 0, 3];