/**
 * addBigNumbers() implementation on the midterm review problems.
 * The function that takes in two “Big Numbers” (arrays of digits in backward order),
 * and returns a new “Big Number” array that represents the sum of the two numbers passed in, 
 */

function addBigNumbers(bigNum1, bigNum2) {
	let result = [];

	let carry = 0; // keep track of carry when two digits are added

	// gets the number of digits in the larger bigNum
	let maxLength = Math.max(bigNum1.length, bigNum2.length);

	// loop through digits / columns from ones to tens to etc.
	for (let i = 0; i < maxLength; i++){
		// add sum of digits in current digit position / column
		let sum = getDigitSafe(bigNum1, i) + getDigitSafe(bigNum2, i) + carry;

		// determine whether to carry to next digit / column
		if (sum >= 10){
			carry = 1;
			sum = sum - 10;
		} else{
			carry = 0;
		}
		
		// add digit sum at end of array, as digits are stored in reverse order
		result.push(sum);
	}

	// check for a carry on the final / highest digit 
	if (carry == 1){
		result.push(carry);
	}
	return result;
}

// returns digit at given index in bigNum if it exists, and 0 otherwise
function getDigitSafe(bigNum, index){
	if (index >= bigNum.length) return 0;
	return bigNum[index];
}

/* Main program */
function TestAddBigNumbers() {
    for (let i = 0; i < BIG_NUMBER_ARRAYS.length; i++) {
      let bigNum1 = BIG_NUMBER_ARRAYS[i].bigNum1;
	  let bigNum2 = BIG_NUMBER_ARRAYS[i].bigNum2;
	  let expectedResult = BIG_NUMBER_ARRAYS[i].result;
	  let output = addBigNumbers(bigNum1, bigNum2);

	  if (checkArraysSame(output, expectedResult)){
	  	console.log("addBigNumbers([" + bigNum1 + "],[" + bigNum2 + "]) -> [" + output + "] ✅");
	  } else{
		console.log("addBigNumbers([" + bigNum1 + "],[" + bigNum2 + "]) -> [" + output + "] ❌ Expected : [" + expectedResult + "]");
		console.log("\t Note: This is trying to verify " + BIG_NUMBER_ARRAYS[i].math + ".");
	  }
	}
}

function checkArraysSame(arr1, arr2){
	if (arr1.length !== arr2.length) return false;
	for (let i = 0; i < arr1.length1; i++){
		if (arr1[i] !== arr2[i]) return false;
	}
	return true;
}

const BIG_NUMBER_ARRAYS = [
	{"bigNum1": [3], "bigNum2": [9], "result": [2, 1], "math": "3 + 9 = 12"},
	{"bigNum1": [1, 1], "bigNum2": [2, 1], "result": [3, 2], "math": "11 + 12 = 23"},
	{"bigNum1": [4, 6, 5, 9], "bigNum2": [7, 6, 8], "result": [1, 3, 4, 0, 1], "math": "9564 + 867 = 10431"},
	{"bigNum1": [9, 9, 9, 9], "bigNum2": [1], "result": [0, 0, 0, 0, 1], "math": "9999 + 1 = 10000"},
]